# Using Docker

The docker technilogy stack was chosen to support the deployment of this application within the
Amazon Web Services (AWS) EC2 cloud service which is the implementation technology behind the GocCloud system.

This application stores its docker related configuration files in the config/docker directory.  The primary tool is docker-compose.  The tool is used by the script bin/docker_cui_create.sh

THe `bin/docker_cui_create.sh --help` command should provide sufficient instruction on how to build docker containers.

The purpose of this document is to assist developers in getting a docker-based developer test environment running on their workstations.

## Containers / Services

The DEAP/CUI/CPP application uses three docker containers: db, redis and web.  These containers are built using the name_docker-compose.yml and name_service.yml (where name is db, redis or web) files found in the directory config/docker.

The name_docker-compose.yml files are mostly similar to each other.  They each make use of the `m4` macro `sinclude()` to include the name_service.yml file.  The `m4` command line utility is a common *nix utility that provides macro text processing services.  In this application it is used to do file import/includes that are not inherently supported by the docker technology.

To build the three images/containers use the following command from the Rails.root directory:

    bin/docker_cui_create.sh db redis web

To build the images/containers in a way where they can be tested on a local development workstation do this:

    bin/docker_cui_create.sh localhost



### db Service

The db service is implemented within a container/image with the name db_server.  The db_server encapsulates an implementation instance of the PostgreSQL version 9.3 relational database management system.  The base platform image is obtained from the official image maintained by the PostgreSQL team on the docker hub website.

### redis Service

The redis service is implemented within a container/image with the name redis_server.  The redis_server encapsulates an implementation instance of the redis-server version 3.2.8.  The base platform image is obtained from the official image maintained by the Redis team on the docker hub website.

### web Service

The web service is implemented within a container/image with the name web_server.  The web_server encapsulates an implementation instance of this application.  The base platform image is obtained from the official image maintained by the Ruby team on the docker hub website.  This base image is version 2.3.3 of RUby.  The web_server image is built up in layers using the config/docker/web_dockerfile configuration file.  On top of the base platform layer is the Ruby gems layer.  This layer consists of all of the RUby gems (aka libraries) used by the DEAP/CUI/CPP application.  The final layer of the web_server image is the actual Rails application.

Using layers allows for faster rebuilds of the web_server image.  For changes that only impact the Rails application, only the top layer of the images is rebuild.  When adding or deleting gems, the gem library layer and the application layer are rebuilt.


### localhost is a special service configuration

Looking at the config/docker/localhost_docker-compose.yml file you will notice that it uses the `m4` macro `sinclude()` to import all three services - db, redis and web.  Also note that it expands on the web service by using the `links:` configuration element.  The `links:` block indicates to the docker system that there are additional services which are to be 'linked' (e.g. made availavle) to the current service.  The web service makes use of the both the db and redis services.

The docker technology stack will configure a special DNS (domain naming service) which relates the name of a linked service to a hostname of the identical value.  This means that within the web service context/image/container in the localhost configuration that the DBHOST system environment variable needs to be set to 'db'; likewise, the REDIS_HOST environment variable needs to be set to 'redis'.

## First Time

The first time that you create the localhost configuration of service containers on your development workstation you will need to set some additional system environment variables in you `.env.local` file.  The first time the web_server is executed it will need to configure the database.  It does this via a rake task `prep:db` which is defined in the file lib/tasks/prep.rake.

The guts of the `prep:db` task is this:

    if DBRESET  &&  Rails.env.development?
      Rake::Task["db:reset"].invoke
    elsif DBMIGRATE
      Rake::Task["db:migrate"].invoke
      if DBSEED
        Rake::Task["db:seed"].invoke
      end
    elsif DBSEED
      Rake::Task["db:seed"].invoke
    end

There are three kernel-level constants used: DBRESET, DBMIGRATE and DBSEED.  These kernel constants are set in `config/initializers/aarp.rb` using the `truth_or_consequences()` method found in the file `lib/truth_or_consequences.rb` which takes a system environment variable and turns it into a boolean constant based upon its string value.

If the system environment variable DBRESET is set to some "truthy" value (eg. 'true', 'yes', 'yep', 'y', 'sure' ) then its corresponding constant will have a true value.  Any other string value for the variable will result in a false value for its constant.

The bottom line is that the environment variable DBRESET must be set to "true" for the first time the docker containers are used on your workstation in the localhost configuration.  This will build the database structure and content using the rake task `db:reset` prior to starting the web application.

After that first time the DBRESET variable should be set to false to avoid rebuilding the database.  On those times in which you containerized database needs to be rebuild you can either use the DBRESET=true method to rebuild everything or just use DBMIGRATE=true or DBSEED=true for a quicker rebuild of the database.


### Accessing the Application

The docker services expose ports to the host machine in a way that does not require you to know their IP address.

The two system environment variables that control the web_server's ports are:  PUMA_PORT and DOCKER_HOST_WEB_PORT.  The default from the file `.env` for PUMA_PORT is 4567.  The default for DOCKER_HOST_WEB_PORT is the same.  This means that you can use the browser on your development workstation to access the Rails application running in the web_server container with this URL:

[http://localhost:4567](http://localhost:4567)


### Conflicts with localhost ports

If you have running natively on your workstation a db, redis or web server that is using the same ports as the DEAP/CUI/CPP application, you can avoid conflicts between you workstation native applications and those same applications that are running within the containers by changing the values of the associated environment variables.  For example, if you are running PostgreSQL natively on your workstation on its normal default port of 5432 and you want to run the db_server container just change the value of DBPORT in your '.env.local' file from 5432 to 15432 (or whatever port you want) and like magic there is not conflict.  The same is true for the REDIS_PORT and DOCKER_HOST_WEB_PORT.


### Startup Problems

After doing `bin/docker_cui_create.sh localhost` you will notice what looks like an error condition when the script terminates.  The is a false error.  We don't know why its showing up.  It can be ignored.  To see what the status is of the system you can always review the logs using this command:

    docker logs web_server

The first time you build the container with the DBRESET=true value, the `bin/docker_cui_create.sh` script to complete before the container has finished its work of starting un the application server.  Viewing the logs will show you that the container is still in the process of doing its `rake db:reset` task.  Be patient - take a coffee break.  The process of configuring the database container from the web container on a developer's workstation will take on the order of 15 minutes on a MacOSX platform.

Here us wgat a building session looks like ...

    ruby-2.3.3@deap Git:PP-552 cpp_feature $ bin/docker_cui_create.sh localhost
    awk:/usr/local/bin/awk
    m4:/usr/bin/m4
    Establishing environment ...
      Sourcing .env ...
      Sourcing .env.development ...
      Sourcing .env.local ...
      Sourcing .env.development.local ...

    Building and launching the application containers from localhost_docker-compose.yml ...
    Command: docker-compose -f localhost_docker-compose.yml -p CPP up -d --build
    Pulling redis (redis:3.2.8)...
    Pulling db (postgres:9.3)...
    Building web
    Creating redis_server
    Creating db_server
    Creating web_server
    bin/docker_cui_create.sh: line 104: 3.2.8:: command not found
    ruby-2.3.3@deap Git:PP-552 cpp_feature $

Note how the last lines ends with "command not found" ... It does not indicate anything wrong with the docker container creation and launch process.  Using the `docker logs` command on any of the contains will show a normal startup.


## bin/dockerinfo

This utility will display some vital information about all of the docker containers on your workstation.  It also displays a small knowledgebase of docker commands that are usefull on a developer's workstation.

Here is an example output when all three containers are running.

    ruby-2.3.3@deap Git:PP-552 cpp_feature $ bin/dockerinfo

    ┌──────────────┬────────────────┬─────────┬───────────────────┬────────────┐
    │ Container ID │ Container Name │ Status  │ Container IP:Port │ Host IP    │
    ├──────────────┼────────────────┼─────────┼───────────────────┼────────────┤
    │ e31e8d6caaf4 │ web_server     │ running │ 172.23.0.4:4567   │ 172.23.0.1 │
    │ 83f78a331dcc │ db_server      │ running │ 172.23.0.3:15432  │ 172.23.0.1 │
    │ bbf17c93299f │ redis_server   │ running │ 172.23.0.2:6379   │ 172.23.0.1 │
    └──────────────┴────────────────┴─────────┴───────────────────┴────────────┘

Tge rest if the output is a summary of useful docker commands.  Those command with more detailed description is shown in the next section of this document.

## Useful Docker Commands

### docker logs (container name)
Shows the log file of a container which is a little confusing semantically because what is really being shown is the STDOUT and STDERR output.  Any container application which writes its log information to a file will have its log information in that designated file and not STDOUT or STDERR.  The way to see those kinds of log files is to run a BASH shell on running container, `cd` into the proper log directory and `cat` or `less` the chosen log file.

### docker exec -it (container name) bash
Opens a bash shell on a running container.  This is a preferred way of accessing the running container.  The typical docker documentation tell you to do a `docker attach` which only connects your host's terminal window to the STDOUR, STDERR and STDIN streams of the container.  Most (if not all) containerized applications are running in the foreground.  Attaching to the standard I/O stream does not give you the ability to poke around and make changes to the environment as necessary.

### docker (start|stop) (container name)
Starts or stops a container.  You can think of a container as a virtual machine which can be paused and restarted from the point at which it was paused.  That is what the stop and start docker commands allow you to do.

### docker images
Shows all docker images on your workstation.  These are images from which containers are built.  Some images have descriptive names. Others may only have an image ID hex string.  The images with only the image ID are most likely layers that are built on top of other images to form a container.

### docker inspect (container name)
Show details about a container's configuration.  The result is a JSON string.  Depending on how your terminal/console window is configured this JSON string will be easy to read.

### docker ps
Shows all currently running containers.  Simple to a standard *NIX `ps` command.

### bin/delete_docker_images_etal.rb --help
Utility to delete docker images and containers.  If you enter no parameters you will get the same kind of output generated by the `docker images` command.  Using the `--help` parameter will provide a list of other command line options.  The two currently supported are:

    --delete-containers
    --delete-images

They can be used together or separately.  This utility program is used to return your workstation to a blank slate by deleting all the local docker containers and images known to your host computer.  You can delete the containers and rebuild them from the existing local images.  This avoids the need to download the required images from the [docker hub website](https://hub.docker.com/).


### bin/docker_cui_create.sh db redis web
Builds and starts this project's containers.  The configuration for the different containers and images used by this application are located in the `config/docker` directory.  These config files are processed by the `docker_cui_create.sh` script through a standard *NIX `m4` text preprocessor.  The resulting configuration files are temporarily stored in the Rails.root directory.  The `.gitignore` file has been modified to ignore docker configuration files in the root directory.

The reason the configuration files are pre-processed and moved into the root directory of the projects is because the docker technology stack as of its current version has significant known errors w/r/t to its use of filesystem paths.  The most stable way to handle filesystem paths is to put the configuration files in the root directory.  This however is poor project organization.

Also the current version of the docker technology stack no longer supports the `extends` capability found in older versions.  The extends capability allowed for a docker container to make use of a set of base services and extend the configuration for different deployment environments.  This amounted to a way in which individual services could be configuration managed outside of their deployed configuration.  The functional was lost when the docker system was redesigned/reprogrammed from the `python` language into the `go` language.



