# This migration is a result of an audit done of the database system by
# a VA team that does that kind of thing.  They said we must wo we do.

class AddForeignKeys < ActiveRecord::Migration

  FK_INDEX_CHANGES = [
    [ :alerts,                                  :site ],
    [ :appointment_objects,                     :contention ],
    [ :boilerplate_messages_dbq_informations,   :boilerplate_message ],
    [ :boilerplate_messages_dbq_informations,   :dbq_information ],
    [ :claims,                          :regional_office ],
    [ :clarification_details,           :contention ],
    [ :clinics,                         :site ],
    [ :contention_details,              :contention ],
    [ :contentions,                     :claim ],
    [ :contentions,                     :exam_request ],
    [ :contentions_dbq_informations,    :contention ],
    [ :contentions_dbq_informations,    :dbq_information ],
    [ :contentions_evaluations,         :contention ],
    [ :contentions_evaluations,         :evaluation ],
    [ :contentions_examinations,        :contention ],
    [ :contentions_examinations,        :examination ],
    [ :diagnoses,                       :minor_system ],
    [ :diagnoses_dbq_informations,      :dbq_information ],
    [ :diagnoses_dbq_informations,      :diagnosis ],
    [ :dm_assignments,                  :diagnosis ],
    [ :dm_assignments,                  :diagnosis_modifier ],
    [ :evaluation_logs,                 :evaluation ],
    [ :exam_request_histories,          :exam_request ],
    [ :examination_histories,           :examination ],
    [ :examination_notes,               :examination ],
    [ :examination_review_questionnaires,   :examination ],
    [ :examination_schedules,               :examination ],
    [ :examinations,                        :claim ],
    [ :examinations,                        :exam_request ],
    [ :examinations,                        :examination_state ],
    [ :general_questions,                   :minor_system ],
    [ :general_questions_dbq_informations,  :dbq_information ],
    [ :general_questions_dbq_informations,  :general_question ],
    [ :major_systems,                       :evaluation_template ],
    [ :medical_specialties_providers,       :medical_specialty ],
    [ :medical_specialties_providers,       :provider ],
    [ :minor_systems,                       :major_system ],
    [ :notification_logs,                   :claim ],
    [ :preferred_geo_locations,             :claim ],
    [ :qm_assignments,                      :general_question ],
    [ :qm_assignments,                      :question_modifier ],
    [ :rejections,                          :contention ],
    [ :service_periods,                     :claim ],
    [ :site_role_sets,                      :site ],
    [ :site_role_sets,                      :user ],
    [ :supervised_clinicians,               :user ],
    [ :supervising_clinicians,              :user ],
    [ :symp_diag_relations,                 :diagnosis ],
    [ :symp_diag_relations,                 :symptom ],
    [ :symptoms,                            :minor_system ],
    [ :symptoms_dbq_informations,           :dbq_information ],
    [ :symptoms_dbq_informations,           :symptom ],
  ]


  def change
    FK_INDEX_CHANGES.each do |change_pair|
      source_table = change_pair.first
      target_model = change_pair.last
      target_table = target_model.to_s.pluralize.to_sym
      column_name  = (target_model.to_s + '_id').to_sym

      begin
        add_index source_table,       column_name
      rescue StandardError
        # trap condition where index already exists
        # also traps condition where standard index name is too long
        #   for example in the join table boilerplate_messages_dbq_informations
        #   where the table already has a customer index.
      end

      add_foreign_key source_table, target_table # defaults to using the '*_id' column

    end # FK_INDEX_CHANGES.each do |change_pair|

  end # def change
end # class AddForeignKeys < ActiveRecord::Migration

