class AddMissingCuiIndexes < ActiveRecord::Migration
  def change
		add_index :clarification_details, :contention_id
		add_index :contention_details, :contention_id
		add_index :contentions, :assigner_id
		add_index :contentions, :reviewed_by
		add_index :diagnoses, :minor_system_id
		add_index :evaluations, :assigner_id
		add_index :evaluations, :evaluation_spec_id
		add_index :evaluations, :primary_evaluation_id
		add_index :evaluations, :user_id
		add_index :evaluations, [:claim_id, :user_id]
		add_index :exam_requests, :exam_request_state_id
		add_index :exam_requests, :site_id
		add_index :examination_schedules, :examination_id
		add_index :examinations, :claim_id
		add_index :examinations, :exam_request_id
		add_index :examinations, :examination_state_id
		add_index :examinations, :site_id
		add_index :general_questions, :minor_system_id
		add_index :major_systems, :evaluation_template_id
		add_index :minor_systems, :major_system_id
		add_index :preferred_geo_locations, :claim_id
		add_index :service_periods, :claim_id
		add_index :site_role_sets, :site_id
		add_index :site_role_sets, :user_id
		add_index :symptoms, :minor_system_id
  end
end