class CreateReferralDocuments < ActiveRecord::Migration
  def change
    create_table :referral_documents do |t|
      t.integer  :referral_document_type_id
      t.integer  :uploader_id
      t.integer  :approver_id
      t.datetime :approved_at
      t.json :content
      t.timestamps null: false
    end
    add_reference   :referral_documents, :referral, foreign_key: true
    add_index       :referral_documents, :referral_id
  end
end
