class CreateVeterans < ActiveRecord::Migration
  def change
    create_table :veterans do |t|
      t.string :ssn, limit: 10, null: false
      t.string :first_name
      t.string :middle_name
      t.string :last_name
      t.string :other_health_insurance_name
      t.json   :content
      t.timestamps null: false
    end
    add_reference   :veterans, :other_health_insurance, foreign_key: true

    add_index       :veterans, :ssn, unique: true
    add_index       :veterans, :first_name
    add_index       :veterans, :last_name
    add_index       :veterans, :other_health_insurance_id
  end
end
