class FixHelptext < ActiveRecord::Migration
  def find_field_by_name(json, name)
    for field in json["form"]["fieldsets"][0]["fieldset"]
      if field["field"]["name"] == name
        return field["field"]
      end
    end
  end

  def up
    Evaluation.all.each do |evaluation|
      next if evaluation.doc.nil?
      dirty = false

      begin
        if evaluation.evaluation_spec && evaluation.evaluation_spec.form && evaluation.evaluation_spec.form.fields
          evaluation.evaluation_spec.form.fields.each do |name, field|
            if field.helptext
              puts "adding helptext to field #{name} on #{evaluation.id}"
              evaluation.doc_will_change!
              find_field_by_name(evaluation.doc, name)["helptext"] = field.helptext
              dirty = true
            end
          end
        end

        if dirty
          puts "saving"
          evaluation.save
        end
      rescue Exception => error
        puts error.message
      end
    end
  end
end