class CreateBooleanFieldsForRecords < ActiveRecord::Migration
  def change
    add_column :contentions, :reviewed_military_service_treatment_records, :boolean
    add_column :contentions, :reviewed_military_service_personnel_records, :boolean
    add_column :contentions, :reviewed_military_enlistment_examination, :boolean
    add_column :contentions, :reviewed_military_separation_examination, :boolean
    add_column :contentions, :reviewed_military_post_deployment_questionnaire, :boolean
    add_column :contentions, :reviewed_dod_form_214_separation_documents, :boolean
    add_column :contentions, :reviewed_vha_treatment_records, :boolean
    add_column :contentions, :reviewed_civilian_medical_records, :boolean
    add_column :contentions, :reviewed_interviews_with_collateral_witnesses, :boolean
    Contention.all.each do |contention|
      contention.records.each do |record|
        field_symbol = map_record_name_to_field_symbol(record[:name])
        contention.update_attributes(field_symbol.to_sym => true) if field_symbol && record[:reviewed] == true
      end
    end
  end
  
  def map_record_name_to_field_symbol(record_name)
    case record_name
    when "Military service treatment records"
      return :reviewed_military_service_treatment_records
    when "Military service personnel records"
      return :reviewed_military_service_personnel_records
    when "Military enlistment examination"
      return :reviewed_military_enlistment_examination
    when "Military separation examination"
      return :reviewed_military_separation_examination
    when "Military post-deployment questionnaire"
      return :reviewed_military_post_deployment_questionnaire
    when "Department of Defense Form 214 Separation Documents"
      return :reviewed_dod_form_214_separation_documents
    when "Veterans Health Administration medical records (VA treatment records)"
      return :reviewed_vha_treatment_records
    when "Civilian medical records"
      return :reviewed_civilian_medical_records
    when "Interviews with collateral witnesses (family and others who have known the veteran before and after military service)"
      return :reviewed_interviews_with_collateral_witnesses
    else
      return nil
    end
  end
end
