require 'sidekiq/web'

DrTurboTax::Application.routes.draw do
  class OnlyAjaxRequest
    def matches?(request)
      request.xhr? || Rails.env.development?
    end
  end

  get 'deleted_referral_docs_for_user' => 'referral_documents#ajax_deleted_referral_docs_for_user', :constraints => OnlyAjaxRequest.new
  post 'delete_referral_doc' => 'referral_documents#ajax_delete_referral_doc', :constraints => OnlyAjaxRequest.new

  get 'load_referral_notes' => 'referral_notes#ajax_load_referral_notes', :constraints => OnlyAjaxRequest.new

  get '/news', to: 'ntm#index'
  resources :ntm, only: [:index]

  get "stage_exam_requests/download_excel_template"
  resources :stage_exam_requests, only: [:new, :create]

  get "pages/privacy_policy"

  resources :support_requests
  resources :examination_notes
  resources :alerts
  resources :boilerplate_messages do
    collection { post :sort }
    get 'generated_html'
  end

  resources :dbq_informations do
    collection { post :sort }
    collection { post :diagnoses_sort }
    collection { post :symptoms_sort}
    collection { post :general_questions_sort}
    get 'generated_html'
  end

  resources :major_systems do
    collection { post :sort }
    get 'generated_html'
  end

  resources :minor_systems do
    collection { post :sort }
    collection { post :diagnoses_sort }
    collection { post :symptoms_sort}
    collection { post :general_question_sort}
    get 'generated_html'
  end

  resources :symptoms do
    collection { post :dbq_informations_sort }
    get 'paged_list', on: :collection
    get 'generated_html'
  end

  resources :diagnoses do
    get 'paged_list', on: :collection
    collection { post :sort }
    get 'generated_html'
    resources :diagnosis_modifiers do
      resources :dm_assignments do
        get 'paged_list', on: :collection
      end
    end
  end

  resources :diagnosis_modifiers do
    get 'paged_list', on: :collection
    get 'generated_html'
  end

  resources :dm_assignments, :only => :index do
    get 'paged_list', on: :collection
    get :index, on: :collection
    post :negative_show_check, on: :member
  end

  resources :general_questions do
    get 'paged_list', on: :collection
    collection { post :sort }
    get 'generated_html'
    resources :question_modifiers do
      resources :qm_assignments
    end
  end

  resources :question_modifiers do
    get 'paged_list', on: :collection
    get 'generated_html'
  end

  resources :qm_assignments do
    get 'paged_list', on: :collection
    get :index, on: :collection
    post :negative_show_check, on: :member
  end

  resources :vbms_r_fact_groups
  resources :full_body_evaluations
  resources :evaluation_templates do
    collection { post :sort }
    get 'paged_list', on: :collection
    get 'generated_html'
  end
  resources :notification_logs
  resources :schedule_examinations
  resources :examination_processors do
    resources :assign_clinician, only: [:new, :update]
  end
#  resources :dashboards

  get 'veterans/search'
  get 'landing/index'
  patch 'landing/index'
  get 'landing/set_site'
  patch 'landing/set_site'
  get 'landing/site_request'
  patch 'landing/site_request'
  get 'dashboards/set_site'
  patch 'dashboards/set_site'



  get 'exam_request/get_clarification'
  get 'exam_request/select_contentions_submit'
  get 'exam_request/handleGetClarification'
  get 'exam_request/cancelExamRequest'
  post 'exam_request/clarification_info_submit'
  post 'exam_request/cancel_submit'

  post 'examination_processors/cancel_examination'

  get 'pingserver' => "application#pingserver"

  match 'ep/verify_veteran_registration/:id' => "examination_processors#verify_veteran_registration", as: "verify_veteran_registration", via: [:get, :post]
  match 'ep/veteran_retrieval/:id' => "examination_processors#veteran_retrieval", as: "veteran_retrieval", via: [:get, :post]
  get 'ep/view_examination/:identifier' => "examination_processors#view_examination", as: :view_examination
  get 'ep/schedule_examination/:id' => "examination_processors#schedule_examination"
  post 'ep/schedule_examination/:id' => "examination_processors#schedule_examination"
  get 'ep/cancel_examination/:id' => "examination_processors#internal_cancel_examination", as: "get_cancel_examination"
  post "ep/cancel_examination/:id" => "examination_processors#internal_cancel_examination", as: "post_cancel_examination"
  get 'ep/review_examination/:id' => "examination_processors#review_examination"
  post 'ep/review_examination/:id' => "examination_processors#review_examination"
  get 'erp/view_exam_request/:id' => "exam_request#view_exam_request", as: :view_exam_request
  get 'erp/view_cancelled_exam_request/:id' => "exam_request#view_cancelled_exam_request"

  get 'ep/acknowledge_examination/:id' => "examination_processors#ack", as: "acknowledge"
  post 'examination_processors/ack_submit'

  get 'ep/reschedule_examination/:id' => "examination_processors#reschedule", as: "reschedule_appointment"
  post 'examination_processors/reschedule_submit'

  get 'er/acknowledge_exam_request/:id' => "exam_request#ack", as: "acknowledge_exam_request"
  post 'exam_request/ack_submit'

  get 'ep/view_cancelled_examination/:id' => "examination_processors#cancelled_examination"

  get 'view_contention/:id' => "exam_request#view_contention", as: "view_contention"


  resources :exam_request
  resources :exam_request_processors

  resources :examinations do
    resources :examfiles, :only => [:create, :destroy]
  end

  get 'site/show'

  resources :site do
    resources :user do
      get 'site_request', on: :member
      patch 'new_site_user', on: :member
      get 'manage_supervisors', on: :member
      patch 'manage_supervisors', on: :member
      post 'manage_supervisors', on: :member
    end

    member do
      get 'access_requests'
    end
  end

  resources :user, controller: 'person' do
    collection do
      get 'access_requests'
      get 'paged_list'
    end

    member do
      get 'access_request'
    end
  end

  get 'pages/help'
  get 'pages/examiners'
  get 'pages/schedulers'
  get 'pages/request_access'
  get 'env', to: 'pages#environment'

  devise_for :users, skip: [:sessions], controllers: {
    sessions: 'sessions',
    registrations: 'registrations',
    omniauth_callbacks: 'omniauth_callbacks'
  }

  devise_scope :user do
    get 'sign_in', to: 'devise/sessions#new', as: :new_user_session
    post 'sign_in' => 'devise/sessions#create', as: :user_session
    delete 'sign_out', to: 'sessions#destroy', as: :destroy_user_session
  end

  resources :claims, only: [:index, :new, :create, :show] do
    resources :contentions, only: [:new, :create, :show, :update] do
      resources :rejections, only: [:new, :create]
      member do
        post :resolve
        put :accept
      end
    end

    resources :evaluations, only: [:new, :create, :show, :edit, :update, :destroy] do
      member do
        get 'review'
        put 'autosave'
        get 'activity'
      end
    end

    member do
      get :details
    end
  end

  resources :full_body_evaluations, only: [:new, :create, :show, :edit, :update, :destroy] do
    member do
      get 'review'
      get 'show'
    end
  end

  namespace :reports do
    get  :pending_exam
    get  :exam_requests_by_date
    post :exam_requests_by_date
    get  :exam_request_status_by_date
    post :exam_request_status_by_date
    get :insufficient_exam_report
    post :insufficient_exam_report
  end

  namespace :searches do
    get :appointments
  end

  namespace :admin do
    resources :evaluation_specs
  end

  namespace 'vista' do
    get 'veterans/search'
    post 'veterans/search'
    get 'veterans/selected'
    post 'veterans/selected'
    get 'veterans/add'
    post 'veterans/add'
  end

  namespace 'api' do
    namespace 'v1' do
      resources :claims, only: [:create]
    end
  end

# FIXME: in application#home set non-cpp user root to dashboard#index

#  root 'dashboards#index'
#  root 'claims#index'
#  root 'landing#index'

  root 'application#home'

  ######################################
  #--- CPP (Provider Portal) Routes ---#


  # CPP API Routes
  namespace 'cpp' do
    namespace 'api' do
      namespace 'v1' do
        get 'veteran_search', to: 'veterans#search', as: :veteran_search
        get 'get_veteran_by_ssn/:ssn', to: 'veterans#get_veteran_by_ssn', as: :get_veteran_by_ssn
      end
    end
  end

  # TODO: Clean up CPP routes

  get 'export_referrals',       to: 'referrals#export_referrals',         as: :export_referrals
  get 'reset_referral_filter',  to: 'referrals#reset_referral_filter',    as: :reset_referral_filter
  get 'reset_filter',           to: 'consultations#reset_filter',         as: :reset_fiter
  get 'export_consultations',   to: 'consultations#export_consultations', as: :export_consultations

  get 'provider/show'

  resources :consultations do
    post 'search', on: :collection
    get 'paged_list', on: :collection
    get 'physician_select', on: :collection
    get 'get_patient_consult_details', on: :collection
    post 'add_referral'
  end

  post 'add_consultation_comment' => 'consultations#add_consultation_comment'

  resources :dashboards do
    get 'paged_list', on: :collection
    get 'get_exam_requests', on: :collection
    get 'cancel_paged_list', on: :collection
  end

  resources :referrals do
    get 'search', on: :collection   # "on: :collection" = no :referral_id in URL route
    get 'paged_list', on: :collection
    get 'filter_by_quicklink', on: :collection
    patch 'update_status'             # has :referral_id in URL route
    post  'va_review', action: 'submit_for_va_review'
    get 'return_va'

    resources :referral_notes,        only: [:create]

    resources :referral_appointments, only: [:create, :destroy, :update] do
      put     'add_to_cprs' => 'referral_appointments#add_to_cprs', :as => 'add_to_cprs'
    end

    resources :referral_documents,    only: [:create, :update] do
      put     'approve' => 'referral_documents#approve',  :as => 'approve'
      delete  'reject'  => 'referral_documents#reject',   :as => 'reject'
      delete  'delete'  => 'referral_documents#delete',   :as => 'delete'
    end
  end

  resources :providers, only: [:show] do
    get 'find_by_npi/:npi' => 'providers#find_by_npi', as: 'find_by_npi', on: :collection
  end

  # FIXME: config/initializers/aarp.rb sets up ENABLE_FEEDBACK as a boolean kernel constant
  if ENV['ENABLE_FEEDBACK'].present?
    PointlessFeedback::Engine.routes.draw do
      resources :messages, :only => [:new, :create, :index]
    end
    mount PointlessFeedback::Engine, :at => '/feedback', :as => 'feedback_engine'
  end


  #############################################################
  ## sidekiq background job queue management

  authenticate :user, lambda { |u| u.is_app_admin? } do
    mount Sidekiq::Web => '/sidekiq'
  end

  authenticate :user, lambda { |u| !u.is_app_admin? } do
    get  '/sidekiq' => "application#home"
  end


  #############################################################
  # SAML controller methods: ID.me SSO login passthru and callback methods
  get '/saml/login' => 'saml#temp_sign_in'
  post '/saml/callback' => 'saml#callback'

  #############################################################
  ########## VA SSOi routes ###################################
  #############################################################
  get '/cui_saml/cuilogin' => 'cui_saml#cui_ssoi'
  post '/saml/cuicallback' => 'cui_saml#cui_callback'

  # FAQ
  resources :faq, only: [:index]

  # Login redirect
  post 'va_redirect' => "application#login"

  # FIXME: get rid of the java-junk (get_*) naming of
  #        resource accessor routes.

  post '/get_facilities/:id'      => "application#get_facilities"
  post '/get_facilities/'         => "application#get_facilities"
  post '/get_providers/:id'       => "application#get_providers"
  post '/get_providers_without_facility/:id'  => "application#get_providers_without_facility"
  post '/get_providers_without_facility/'     => "application#get_providers_without_facility"
  post '/get_providers/' => "application#get_providers_without_facility"

  get '/cpp' => "user_cpp#cpp_sign_in"
  get '/vista' => "user_cpp#vista"
  post '/vista_details' => "user_cpp#vista_details"

  #--- End CPP (Provider Portal) Routes ---#
  ##########################################


end # DrTurboTax::Application.routes.draw do
