# config/initializers/aarp.rb
# Hey! what's so funny about the file name?  Just because the oldest
# developer on the team added this file to the project - that's no excuse
# to LOL.  Its just a name that gets it to the top of the initializer list.

# from Rails.root/lib
require 'truth_or_consequences'

# Create some Kernel-level constants of TrueClass and FalseClass objects
# based upon system environment variables.  See truth_or_consequences for details.

# NOTE: upcase of param is used as key to ENV[]

[
  'ALWAYS_MINIFY_ASSETS',       # determines whether to auto-minify JS/CSS assets regardless of Rails env
  'DBMIGRATE',                  # Used in rake task prep:db ... does not include a reset
  'DBRESET',                    # Used in rake task prep:db ... includes a migration
  'DBSEED',                     # Used in rake task prep:db ... causes a db:seed after migrate or stand-alone
  'DEVELOPER_TESTING',          # Used in application layout to put a banner at the top of every page
  'DISPLAY_FACILITY_DROPDOWNS', # Determines whether Filter dropdowns are visible (Consultation/Referral main page)
  'EMAIL_SANITIZE',             # scrub user-oriented eMail messages
  'ENABLE_FEEDBACK',            # Turn on the feedback messages feature
  'ENABLE_FEEDBACK_EMAIL',      # Turn on feedback notification via eMail
  'ENABLE_FEEDBACK_HIPCHAT',    # Turn on feedback notification via Hipchat
  'ENABLE_FEEDBACK_SLACK',      # Turn on feedback notification via Slack
  'ENABLE_OPENSSL_INITIALIZER', # Developer DEBUG of OpenSSL initialization (impacts access to https integrations)
  'FEEDBACK_EMAIL_SANITIZE',    # Scrub feedback message that are subject to eMail notification
  'NTM_ENABLED',                # Is News and Training Materials website enabled?
  'NTM_S3_ENABLED',             # Is S3 storage of news and training materials enabled?
  'VIA_ACTIVE_FOR_CPP',         # Use the VIA API to access VISTA for CPP feature set
  'VIA_ACTIVE_FOR_CUI',         # Activate Vista login page (which shows up after user logs into CUI)
  'VLER_DAS_ENABLE_NOTIFICATIONS', # Turn on DAS notifications
  'DONT_PRECOMPILE_ASSETS',     # Should only ever be set to true on a developers box (the only place we run rails in development mode right? :-)
].each {|sev| truth_or_consequences(sev)}
