# Top-level object for the Veterans Exchange (VX) API
module VX_API

  # Unable to authenticate CREDENTIALS with AUTH_URL
  class AuthenticationError < RuntimeError; end

  BASE_URL    = ENV['VX_API_BASE_URL']
  AUTH_URL    = ENV['VX_API_AUTH_URL']
  CREDENTIALS = ENV['VX_API_CREDENTIALS']

  class << self

    # Get authorization from VistA. Must be obtained to establish
    # a session for further communication with VistA.
    def authentication_request
      request = Faraday.new(AUTH_URL)

      response = request.post do |req|
        req.headers['Content-Type']   = 'application/json'
        req.headers["Cache-Control"]  = "no-cache"
        req.body                      = CREDENTIALS
      end

      cookie = response.headers['set-cookie']

      unless 200 == response.status
        raise AuthenticationError, "VX API authentication failed"
      end

      return cookie
    end

  end # class << self
end # module VX_API
