# app/services/mvi/proxy_add_to_vista.rb
module MVI

  class << self

  ##############################################################
  def proxy_add_to_vista veteran_hash
    request = MVI_CLIENT.build_request(:prpa_in201301_uv02, attributes: MVI::MSG_TAG_ATTRIBUTES, message: proxy_add_request(veteran_hash))
    request_xml = add_default_header(request.body)
    req_xml = remove_namespaces(request_xml)
    response  = MVI_CLIENT.call(:prpa_in201305_uv02, xml: req_xml)

    data = response.body

    fault_message = data.dig(:fault, :faultstring)
    if fault_message.present? 
      raise MviApiFaultError.new(fault_message)
    end

    ack_code = data.dig(:mcci_in000002_uv01, :acknowledgement, :type_code, :@code)
    
    if ack_code == "AA" || ack_code == "AE"
      ack_detail = data.dig(:mcci_in000002_uv01, :acknowledgement, :acknowledgement_detail)
      ack_message = if ack_detail.is_a? Array
        ack_detail.dig(0).dig(:text)
      else
        ack_detail.dig(:text)
      end
    end

    if ack_code == "AE"
      raise MviApplicationError.new("Proxy Add to Vista request errored out. #{ack_message}")
    elsif ack_code == "AR"
      raise MviApplicationReject.new("MVI Database down. Please try later.")
    end

    ack_message
  end

  def proxy_add_request veteran_hash
    vista_site = "PROXY_VISTA^PI^" + veteran_hash[:station_number] + "^USVHA"
    full_addr  = veteran_hash[:addr]
    street     = full_addr[:street]
    city       = full_addr[:city]
    state      = full_addr[:state]
    country    = full_addr[:country]
    zipcode    = full_addr[:zipcode]

    request = {
      :id => {:@extension=>veteran_hash[:retrieve_person_request_id], :@root=>"1.2.840.114350.1.13.0.1.7.1.1"},
      :creationTime=> { :@value=> MVI.encode_mvi_date(Time.now)},
      :versionCode=>{:@code=>"3.5"},
      :interactionId=>{:@extension=>"PRPA_IN201301UV02", :@root=>"2.16.840.1.113883.1.6"},
      :processingCode=>{:@code=>"T"},
      :processingModeCode=>{:@code=>"T"},
      :acceptAckCode=>{:@code=>"AL"},
      :receiver=>
      {:@typeCode=>"RCV",
        :device=>
          {:@determinerCode=>"INSTANCE",
            :@classCode=>"DEV",
            :id=>{:@root=>"1.2.840.114350.1.13.999.234"},
            :telecom=>{:@value=>"http://servicelocation/PDQuery"}}},
      :sender=>
        {:@typeCode=>"SND",
         :device=>{:@determinerCode=>"INSTANCE", :@classCode=>"DEV", :id=>{:@extension=> MVI::APP_NAME, :@root=>"2.16.840.1.113883.4.349"}}},
      :controlActProcess=>
        {:@classCode=>"CACT",
         :@moodCode=>"EVN",
         :subject=>
          {:@typeCode=>"SUBJ",
           :registrationEvent=>
            {:@classCode=>"REG",
              :@moodCode=>"EVN",
              :id=>{:@nullFlavor=>"NA"},
              :statusCode=>{:@code=>"active"},
              :subject1=>
                {:@typeCode=>"SBJ",
                 :patient=>
                  {:@classCode=>"PAT",
                    :id=>{:@extension=> veteran_hash[:patient_icn], :@root=>"2.16.840.1.113883.4.349"},
                    :patientPerson=>
                      {:name=>{:@use=>"L", :given=>veteran_hash[:fname], :family=>veteran_hash[:lname]},
                      :telecom=>{:@value=>veteran_hash[:telecom_value], :@use=>veteran_hash[:telecom_usage]},
                      :administrativeGenderCode=>{:@code=>veteran_hash[:gender]},
                      :birthTime=>{:@value=>veteran_hash[:birth_date]},
                      :multipleBirthInd=>{:@value=>"false"},
                      :addr=>{:@use=>veteran_hash[:addr_usage], :streetAddressLine=>street, :city=>city, :state=>state, :country=>country, :postalCode=>zipcode},
                      :asOtherIDs=>
                        [{:@classCode=>"SSN",
                          :id=>{:@extension=> veteran_hash[:ssn], :@root=>"2.16.840.1.113883.4.1"},
                          :statusCode=>{:@code=>"1"},
                          :scopingOrganization=>{:@classCode=>"ORG", :@determinerCode=>"INSTANCE", :id=>{:@root=>"2.16.840.1.113883.4.1"}}},
                         {:@classCode=>"PAT",
                          :id=>{:@extension=> vista_site, :@root=>"2.16.840.1.113883.4.349"},
                          :scopingOrganization=>{:@classCode=>"ORG", :@determinerCode=>"INSTANCE", :id=>{:@root=>"2.16.840.1.113883.4.349"}}},
                         {:@classCode=>"patientVeteran",
                          :id=>{:@extension=>"Y", :@root=>"2.16.840.1.113883.4.349"},
                          :scopingOrganization=>{:@classCode=>"ORG", :@determinerCode=>"INSTANCE", :id=>{:@root=>"2.16.840.1.113883.4.349"}}},
                         {:@classCode=>"patientServiceConnected",
                          :id=>{:@extension=>"Y", :@root=>"2.16.840.1.113883.4.349"},
                          :scopingOrganization=>{:@classCode=>"ORG", :@determinerCode=>"INSTANCE", :id=>{:@root=>"2.16.840.1.113883.4.349"}}},
                         {:@classCode=>"patientType",
                          :id=>{:@extension=>"1", :@root=>"2.16.840.1.113883.4.349"},
                          :scopingOrganization=>{:@classCode=>"ORG", :@determinerCode=>"INSTANCE", :id=>{:@root=>"2.16.840.1.113883.4.349"}}}]},
                  :providerOrganization=>
                    {:@classCode=>"ORG",
                     :@determinerCode=>"INSTANCE",
                     :id=>{:@root=>"1.2.840.114350.1.13.99998.8734"},
                     :name=>veteran_hash[:clinic_name],
                     :contactParty=>{:@classCode=>"CON", :telecom=>{:@value=>veteran_hash[:clinic_phone]}}}}},
          :custodian=>
            {:@typeCode=>"CST",
             :assignedEntity=>
              {:@classCode=>"ASSIGNED",
                :id=>{:@root=>"1.2.840.114350.1.13.99998.8734"},
                :assignedOrganization=>{:@classCode=>"ORG", :@determinerCode=>"INSTANCE", :name=>veteran_hash[:clinic_name]}
              }
            }
          }
        }
      }
    }
    request
  end

  end # class << self
end # module MVI