class TraumaticBrainInjuryEvaluationPresenter < EvaluationPresenter
  presenter_for bodySystem: 'Traumatic Brain Injury', base_document: 'tbi.xml'

  def modify_document

    evaluationTitle = evaluation.evaluation_spec.title
    form = FML::Form.from_json(evaluation.doc.to_json)
    
    process(form, "memoryAttentionConcentrationExecutiveFunctions", "memoryAttentionConcentrationExecutiveFunctionsSelect", "facetMemorySymptom", true)
    process(form, "veteranJudgment", "veteranJudgmentSelect", "facetJudgementSymptom", true)
    process(form, "socialInteraction", "socialInteractionSelect", "facetSocialSymptom", true)
    process(form, "veteranOrientation", "veteranOrientationSelect", "facetOrientationSymptom", true)
    process(form, "motorActivity", "motorActivitySelect", "facetMotorSymptom", true)
    process(form, "visualSatialOrientation", "visualSatialOrientationSelect", "facetVisualSymptom", true)
    process(form, "subjectiveSymptoms", "subjectiveSymptomsSelect", "facetSubjectiveSymptom", true)
    process(form, "neurobehavioralEffects", "neurobehavioralEffectsSelect", "facetNeuroSymptom", true)
    process(form, "veteranCommunication", "veteranCommunicationSelect", "facetCommunicationSymptom", true)
    process(form, "stateOfConsciousness", "stateOfConsciousnessSelect", "facetConsciousnessSymptom", true)
  end

  def process(form, parentFieldName, fieldName, tag, addValueTag)
    fieldSelected = getValue(form, parentFieldName)
    if fieldSelected
      fieldValue = getRatingCalculatorValue(form, fieldName)
      if fieldValue.to_s.strip.length > 0
        addTag("tbi", tag, fieldValue, addValueTag)
      end
    end
  end

  def addTag(namespace, tagName, tagValue, addValueTag)
    evaluation_root.xpath("tbi:tbiFacts").first << getTag(namespace, tagName, tagValue, addValueTag)
  end

  #def addSymptoms(tag, value)
    #addTag("cbsf", tag, value)
    #evaluation_root.xpath("cbsf:commonBodySystemFacts").first << getTag(namespace, tagName, tagValue)
  #end

  def getTag(namespace, tagName, tagValue, addValueTag)
    tag = Nokogiri::XML::Node.new(namespace+":"+tagName, document)

    if addValueTag
      valueTag = Nokogiri::XML::Node.new(namespace+":value", document)
      valueTag.content = tagValue
      tag << valueTag
    else
      tag.content = tagValue
    end
    tag
  end

  def getValue(form, fieldName)
    form.fields[fieldName].value
  end

  def getRatingCalculatorValue(form, fieldName)
    fields = evaluation.evaluation_spec.ratings_calculator_fields.select do |h|
    if h[:name] == fieldName
        h
      end
    end
    filteredFieldValue = fields.collect do |ratings_calculator_field|
      form_field = form.fields[ratings_calculator_field[:name]]
      if form_field && (form_field.value == true || form_field.value == ratings_calculator_field[:calculator_value])
        ratings_calculator_field[:calculator_value]
      end
    end.compact
    filteredFieldValue[0]
  end
end
