class SkinEvaluationPresenter < EvaluationPresenter
  presenter_for bodySystem: 'Skin', base_document: 'skin.xml'

  EXAM_TO_XML_FIELD_MAP = [
    "percentBodyAffected" => "percentAffectingEntireBodyList",
    "percentExposed" => "percentAffectingExposedAreasList"
  ]
  
  def modify_document
    evaluation_root.xpath("skf:skinFacts/skf:SkinDiagnoses/skf:value").first.content = evaluation.evaluation_spec.title
    add_presentable_symptoms(namespace: 'skf', basename: 'skin', symptoms_element: 'SkinSymptoms')
    form = FML::Form.from_json(evaluation.doc.to_json)
    EXAM_TO_XML_FIELD_MAP.each do |fact|
      exam_field_name = fact.keys.first
      xml_field_name = fact[exam_field_name]
      if form.fields[exam_field_name] && form.fields[exam_field_name].to_h.has_key?(:value)
        fact_node = Nokogiri::XML::Node.new("skf:#{xml_field_name}", document)
        fact_node.content = form.fields[exam_field_name].value
        evaluation_root.xpath("skf:skinFacts").first << fact_node
      end
    end
  end
end
