class MusculoskeletalWristEvaluationPresenter < EvaluationPresenter
  presenter_for bodySystem: 'Musculoskeletal-Wrist', base_document: 'wrist.xml'

  def modify_document
    evaluation_root.xpath("wf:wristFacts/wf:wristDiagnoses/wf:value").first.content = evaluation.evaluation_spec.title
    add_presentable_symptoms(namespace: 'wf', basename: 'wrist', after: 'wristDiagnoses')

    fields = FML::Form.from_json(evaluation.doc.to_json).fields

    # this is a boolean field in xsd, from a dropdown in the form
    setfield('//wf:ambidextrous', to: ( fields['dominantHand'].value == 'Ambidextrous') )

    setfield_required('//wf:dorsiflexionActualDegrees', fields['initialRomDorsiflexion'].value)
    setfield_required('//wf:dorsiflexionDeLucaDegrees', fields['repetitiveRomDorsiflexion'].value)

    setfield_required('//wf:palmarFlexionActualDegrees', fields['initialRomPalmarFlexion'].value)
    setfield_required('//wf:palmarFlexionDeLucaDegrees', fields['repetitiveRomPalmarFlexion'].value)

    setfield_required('//wf:ulnarDeviationActualDegrees', fields['initialRomUlnarDeviation'].value)
    setfield_required('//wf:ulnarDeviationDeLucaDegrees', fields['repetitiveRomUlnarDeviation'].value)

    setfield_required('//wf:radialDeviationActualDegrees', fields['initialRomRadialDeviation'].value)
    setfield_required('//wf:radialDeviationDeLucaDegrees', fields['repetitiveRomRadialDeviation'].value)

    add_parent_evaluations(evaluation, "//wf:wristFacts")
  end
end
