class MusculoskeletalToeEvaluationPresenter < EvaluationPresenter
  presenter_for bodySystem: 'Musculoskeletal-Toe', base_document: 'common.xml'
  def modify_document
    evaluation_root.xpath("cbsf:commonBodySystemFacts/cbsf:diagnoses/cbsf:value").first.content = evaluation.evaluation_spec.title

    add_presentable_symptoms(namespace: 'cbsf', basename: 'commonBodySystem', symptoms_element: 'symptoms')

    add_parent_evaluations(evaluation, "//cbsf:commonBodySystemFacts")
  end
end
