# == Schema Information
#
# Table name: vbms_r_fact_groups
#
#  id                  :integer          not null, primary key
#  name                :string
#  namespace           :string
#  fact_block_tag_name :string
#  diagnosis_tag_name  :string
#  symptom_tag_name    :string
#  document_title      :string
#  created_at          :datetime         not null
#  updated_at          :datetime         not null
#  diagnosis_info      :text
#  symptom_info        :text
#  additional_fields   :string
#  text                :string
#

class VbmsRFactGroup < ActiveRecord::Base
  
  serialize :diagnosis_info, Hash
  serialize :symptom_info, Hash
  
  def diagnoses_which_match(the_list_of_diagnostic_codes)
    the_matching_codes = Array.new
    the_list_of_diagnostic_codes.split(',').each do |the_code_to_check|
      if( self.contains(the_code_to_check) )
        the_matching_codes << the_code_to_check
      end
    end
    return the_matching_codes
  end
  
  def symptom_string_for(the_symptom_name)
    if( self.symptom_info.key?(the_symptom_name) )
      return self.symptom_info[the_symptom_name]
    else
      return the_symptom_name
    end
  end

  def contains(the_diagnostic_code)
    return self.diagnosis_info.key?(the_diagnostic_code)
  end

  def diagnosis_string_for(the_diagnostic_code)
    return self.diagnosis_info[the_diagnostic_code][:diagnosis_string]
  end
  
  def diagnosis_modifier_string_for(the_diagnostic_code, the_diagnosis_modifier_name, the_diagnosis_modifier_value)
    return_string = ""
    if (self.diagnosis_info[the_diagnostic_code][:modifiers][the_diagnosis_modifier_name] == nil)
      return_string = "DIAGNOSIS MODIFIER ASSIGNMENT NAME NOT FOUND: " + the_diagnosis_modifier_name
    elsif  (self.diagnosis_info[the_diagnostic_code][:modifiers][the_diagnosis_modifier_name][:strings][the_diagnosis_modifier_value] == nil)
      return_string = "DIAGNOSIS MODIFIER VALUE NOT FOUND: " + the_diagnosis_modifier_value
    else
      return_string = self.diagnosis_info[the_diagnostic_code][:modifiers][the_diagnosis_modifier_name][:strings][the_diagnosis_modifier_value]
    end
    return return_string
  end
  
  def diagnosis_modifier_fields_for(the_diagnostic_code, the_diagnosis_modifier_name)
    if (self.diagnosis_info[the_diagnostic_code][:modifiers][the_diagnosis_modifier_name] == nil)
      return [the_diagnosis_modifier_name + "_NOT_FOUND"]
    else
      return self.diagnosis_info[the_diagnostic_code][:modifiers][the_diagnosis_modifier_name][:fields]
    end
  end
  
end
