# == Schema Information
#
# Table name: referral_notes
#
#  id          :integer          not null, primary key
#  content     :json
#  created_at  :datetime         not null
#  updated_at  :datetime         not null
#  referral_id :integer
#

class ReferralNote < ActiveRecord::Base
  has_paper_trail

  belongs_to :referral
  validates_presence_of :notes

  autowire_content_fields :user, :notes

  class << self
    def add_note(referral, user, note)
      raise ArgumentError unless referral.is_a?(Referral) && user.is_a?(User) && note.is_a?(String)

      ref_note              = ReferralNote.new
      ref_note.referral_id  = referral.id
      ref_note.content      = content(referral, user, note)
      ref_note.save!
      ref_note
    end

    def delete_document_note(referral, user, document, delete_reason)
      note = %(
        Document <strong>#{document.document_name}</strong> was deleted by #{user.name}.<br/>
        The Reason for deletion was:<br/>
        #{delete_reason}
      ).html_safe
      ReferralNote.add_note(referral, user, note)
    end

    private

    def content(referral, user, note)
      {
          veteran_id: referral.veteran_id,
          consultation_id: referral.consultation_id,
          referral_id: referral.id,
          user: user.id,
          notes: note
      }
    end
  end

end
