# == Schema Information
#
# Table name: qm_assignments
#
#  id                   :integer          not null, primary key
#  name                 :string
#  label                :string
#  exam_response_fields :string
#  general_question_id  :integer
#  question_modifier_id :integer
#  created_at           :datetime         not null
#  updated_at           :datetime         not null
#  negative_show        :boolean          default(FALSE), not null
#  position             :integer
#

class QmAssignment < ActiveRecord::Base
  include ContentManagerHelper
  belongs_to :general_question
  belongs_to :question_modifier

  before_validation :set_name
  after_create :append_id_to_name
  scope :order_by_position, -> () { order("position ASC") }


  FIELDS_FOR_RESULTSET = {
    0 => 'qm_assignments.name',
    1 => 'qm_assignments.label',
    2 => 'general_questions.name',
    3 => 'question_modifiers.name',
    4 => 'question_modifiers.mod_type'
  }

  class << self
    def filter(params={})
      query = all.joins(:general_question).joins(:question_modifier)

      unless params[:search][:value].blank?
        query = query.where('qm_assignments.name ilike :search OR qm_assignments.label ilike :search OR general_questions.name ilike :search OR question_modifiers.name ilike :search OR question_modifiers.mod_type ilike :search', :search => "%#{params[:search][:value]}%")
      end
      query
    end
  end

  def get_general_question
    return self.general_question
  end

  def get_question_modifier
    return self.question_modifier
  end

  def build_html(identifier)
    @the_html = the_html_template_for_a_question_modifier_association
#    if self.mod_type == "checkbox"
#      @bhtml = base_without_label_html.clone
#      @bhtml.gsub!('[HTML for Modifier Type]', build_checkbox_html())
#    elsif self.mod_type == "radio"
#      @bhtml.gsub!('[HTML for Modifier Type]', build_radio_html())
#    elsif self.mod_type == "single_select"
#      @bhtml.gsub!('[HTML for Modifier Type]', build_single_select_html())
#    elsif self.mod_type == "multi_select"
#      @bhtml.gsub!('[HTML for Modifier Type]', build_multi_select_html())
#    elsif self.mod_type == "date"
#      @bhtml.gsub!('[HTML for Modifier Type]', build_date_html())
#    elsif self.mod_type == "textarea"
#      @bhtml.gsub!('[HTML for Modifier Type]', build_textarea_html())
#    end
    @the_html.gsub!('[Modifier Label]', self.label.to_s)
    @the_html.gsub!('[identifier_base]', identifier)
    @the_html.gsub!('[Modifier Name]', self.name.to_s)
#binding.pry #cs
    if (self.question_modifier != nil)
      @the_html.gsub!('[HTML for Modifier Type]', self.question_modifier.build_html(self.name.to_s,identifier))
    end
#binding.pry #cs
    return @the_html
  end

  def set_name
    if self.general_question.present? && self.question_modifier.present?
      self.name = clean_name(self.general_question.name + "_" + self.question_modifier.name)
    end
  end

  def append_id_to_name
    self.update_attribute(:name, "#{self.name}_#{self.id}")
  end


  private

    def the_html_template_for_a_question_modifier_association
      the_html_template =
        '<div id="question_modifier_container-[Modifier Name]-[identifier_base]"'    +
            ' class="container question_modifier" >'                                 +
        	'<span  id="question_modifier_label-[Modifier Name]-[identifier_base]"'    +
        	      ' class="label question_modifier">'                                  +
  		      '[Modifier Label]'                                                        +
        	'</span>'                                                                   +
          '[HTML for Modifier Type]'                                                  +
        '</div>'

      return the_html_template
    end



end
