# == Schema Information
#
# Table name: medical_specialties
#
#  id         :integer          not null, primary key
#  sequence   :string           not null
#  title      :string           not null
#  deleted_at :datetime
#

class MedicalSpecialty < ActiveRecord::Base
  has_and_belongs_to_many :providers
  acts_as_paranoid

  #######################################################################
  ###
  ##    The Eigen class
  #

  class << self

    # Add a new medical specialty from the npi registry provider
    def add_new_specialty(npi_registry_provider)
      if MedicalSpecialty.last.nil?
        # Start of sequence when accessing the actual NpiRegistry to seed the database
        sequence = "00001000"
      else
        sequence = (MedicalSpecialty.last.sequence.to_i + 1000).to_s.rjust(8, "0")
      end
      MedicalSpecialty.create(
              sequence: sequence,
              title: npi_registry_provider["taxonomies"].first["desc"])
    end
  end # class << self

end
