# == Schema Information
#
# Table name: examinations
#
#  id                                              :integer          not null, primary key
#  title                                           :string
#  exam_date                                       :datetime
#  state                                           :integer
#  exam_id                                         :integer
#  clinician                                       :integer
#  created_at                                      :datetime         not null
#  updated_at                                      :datetime         not null
#  site_id                                         :integer
#  examination_state_id                            :integer
#  active                                          :boolean
#  examfile                                        :string
#  exam_request_id                                 :integer
#  purpose                                         :string
#  evaluation_id                                   :integer
#  examination_state_start_date                    :datetime
#  reviewed_at                                     :datetime
#  reviewed_by                                     :integer
#  interview                                       :text
#  plan                                            :text
#  examfiles                                       :string           default([]), is an Array
#  claim_id                                        :integer
#  cancellation_reason                             :text
#  identifier                                      :string
#  acknowledged                                    :boolean
#  clinician_acknowledged                          :boolean
#

class Examination < ActiveRecord::Base
  belongs_to :examination_state
  belongs_to :site
  belongs_to :claim
  belongs_to :parent, class_name: 'ExamRequest', foreign_key: 'exam_request_id'
  belongs_to :clinician_user, class_name: 'User', foreign_key: 'clinician'
  belongs_to :exam_request

  delegate :name, :code, to: :examination_state


#cs  has_one :evaluation, dependent: :destroy
  has_one :full_body_evaluation, dependent: :destroy  #cs
  has_one :examination_review_questionnaire
  has_and_belongs_to_many :contentions

  has_many :examination_schedules
  has_many :examination_notes

  after_create :build_associated_evaluation

  accepts_nested_attributes_for :examination_review_questionnaire

#cs  before_validation :create_guid

  # attr_accessor :examfile
  mount_uploaders :examfiles, ExamfileUploader
  validate :examfiles_size

  scope :scheduled_site_exams, -> (current_user) { joins(:site => :site_role_sets).joins(:examination_state)
                                                    .where(examination_states: {code: ['SCHEDULED']})
                                                    .where(site_role_sets: {user_id: current_user.id, scheduling: true}) }

  RECORD_FIELD_LABEL_MAP = {
    :reviewed_not_indicated => "Not indicated",
    :reviewed_military_service_treatment_records => "Military service treatment records",
    :reviewed_military_service_personnel_records => "Military service personnel records",
    :reviewed_military_enlistment_examination => "Military enlistment examination",
    :reviewed_military_separation_examination => "Military separation examination",
    :reviewed_military_post_deployment_questionnaire => "Military post-deployment questionnaire",
    :reviewed_dod_form_214_separation_documents => "Department of Defense Form 214 Separation Documents",
    :reviewed_vha_treatment_records => "Veterans Health Administration medical records (VA treatment records)",
    :reviewed_civilian_medical_records => "Civilian medical records",
    :reviewed_interviews_with_collateral_witnesses => "Interviews with collateral witnesses (family and others who have known the veteran before and after military service)"
  }

  FIELDS_FOR_RESULTSET = {
    0 => 'examination_schedules.exam_date_time',
    1 => ['claims.first_name', 'claims.last_name'],
    2 => 'contention_details.name',
    3 => 'examination_states.name',
    5 => 'sites.name',
    6 => 'users.name'
  }

  class << self
    def cancel_filter(params={}, current_user)

      query = Examination.scheduled_site_exams(current_user)
                .joins(:claim).joins(:contentions => :contention_details).joins(:examination_state)
                .joins(:site).joins(:clinician_user)
                .joins(:exam_request).joins(:examination_schedules).where(examination_schedules: {active: true})

      return query
    end
  end

  def assign_a_clinician(clinician_user_id)
#binding.pry #cs
    self.clinician = clinician_user_id
   # evaluation.user_id = clinician_user_id
#binding.pry #cs
   # evaluation.save
  end

  def set_the_creating_user(creator_user_id)
#binding.pry #cs
#cs    if evaluation.present?
#cs    evaluation[:assigner_id] = creator_user_id
#cs#binding.pry #cs
#cs      evaluation.save
    if full_body_evaluation.present?
      full_body_evaluation[:assigner_id] = creator_user_id
#binding.pry #cs
      full_body_evaluation.save
    end
  end

  def reviewed?
#binding.pry #cs
    reviewed_at.nil? ? false : true
  end

  def review!(reviewed_by = nil)
#binding.pry #cs
    self.update_attributes(reviewed_at: Time.now, reviewed_by: reviewed_by) unless self.reviewed?
  end

  def one_or_more_reviewed_checkboxes_selected?
    RECORD_FIELD_LABEL_MAP.keys.any? { |k| self[k] }
  end

  def already_submitted?
    !EvaluationLog.where(evaluation_id: self.full_body_evaluation.id, message: "VLER-DAS evaluation submission").empty?
  end

  ##
  #   decorators
  ##

  def clinician_name
    clinician = User.find(self.clinician)
    "#{clinician.first_name} #{clinician.last_name}"
  end

  def most_recent_active_appointment
    self.examination_schedules.where(active: true).last
  end

  private

#cs  def create_guid
#csbinding.pry  #cs
#cs    self.guid = SecureRandom.uuid
#csbinding.pry #cs
#cs  end

  def build_associated_evaluation
    # build default profile instance. Will use default params.
    # The foreign key to the owning User model is set automatically
#    binding.pry

#    build_evaluation
    temp_contention = contentions.first
    @contention = Contention.find(temp_contention.id) #This is a stop-gap measure. Need to be replaced
    @claim = Claim.find(@contention.claim_id)
#binding.pry #cs
#cs original    @evaluation = @claim.evaluations.build(evaluation_params)
    @evaluation = FullBodyEvaluation.new(evaluation_params)
#binding.pry #cs
    @evaluation.claim_id = @claim.id
    @evaluation.examination_id = self.id
#    @evaluation.create_guid
#binding.pry #cs
#    if @evaluation.save
    if @evaluation.save(:validate => false)
#      binding.pry #cs
      @claim.contentions.find(temp_contention.id).evaluations << @evaluation
      self.evaluation_id = @evaluation.id
#binding.pry #cs
    end
    @evaluation.set_highlighting_based_on_associated_dbqs
#cs    set_highlighting_based_on_associated_dbqs(@evaluation)
    self.save(:validate => false)
  #  binding.pry #cs

#    @evaluation=Evaluation.new(:claim_id=>2, :examination_id=> id)
#    @evaluation.save(:validate=>false)
#    binding.pry
    true  # Always return true in callbacks as the normal 'continue' state
          # Assumes that the default_profile can **always** be created.
          # or
          # Check the validation of the evaluation. If it is not valid, then
          # return false from the callback. Best to use a before_validation
          # if doing this. View code should check the errors of the child.
          # Or add the child's errors to the User model's error array of the :base
          # error itemend

  end

  def evaluation_params
    local_specs = EvaluationSpec.group_by_body_system
#binding.pry #cs
    local_specs.each{ |body_system|
#      binding.pry #cs
#cs 2016-09-13      if body_system[0] == "Unclassified"
#cs 2016-09-14      if body_system[0] == "Full_Body"
      if body_system[0] == "Fullbody"
#        binding.pry #cs
        body_system[1].each{ |evaluation_spec_info|
          if evaluation_spec_info[0] == "Full-Body Evaluation"
#            binding.pry #cs
            return { 'evaluation_spec_id' => evaluation_spec_info[1] }
          end
        }
      end
    }
#    binding.pry #cs
#    params.require(:evaluation).permit(:evaluation_spec_id, :vha_user_vista_access_code, :vha_user_vista_verify_code,
#                                       :vha_user_electronic_signature, :user_id)
  end

  def examfiles_size
    size_array = self.examfiles.collect { |e| e.size }
    if size_array.inject(0, :+) > 125.megabytes
      self.errors.add(:examfiles, "combined file size should be less than 125MB")
    end
  end
end
