class ExamResponseGenerationFramework
  
  def initialize(the_set_of_vbms_r_fact_groups)
    @the_internal_framework = Array.new
    the_set_of_vbms_r_fact_groups.each do |the_fact_group_to_use|
      the_framework_entry = { :fact_group => the_fact_group_to_use, :diagnoses => Array.new, :unattached_symptoms => Array.new, :unattached_diagnosis_modifiers => Array.new }
      @the_internal_framework << the_framework_entry
    end
#binding.pry #cs
  end
  
  def accepts(the_html_node_to_add)
    if( !the_html_node_to_add.nil? && !the_html_node_to_add['id'].nil? )
#binding.pry #cs
      the_id = the_html_node_to_add['id']
     # case the_html_node_to_add['id']
     #   when -> (the_id) { the_id.starts_with?('symptom-') }
     #
#binding.pry #cs
       case
         when the_id.starts_with?('symptom-')
          the_symptom_name = the_html_node_to_add['name'].partition('-').last
          the_symptom_name = the_symptom_name.partition('-').first
          the_associated_diagnoses = the_html_node_to_add['value']
          @the_internal_framework.each do |the_framework_to_check|
            the_matching_diagnoses = the_framework_to_check[:fact_group].diagnoses_which_match(the_associated_diagnoses)
#binding.pry #cs
            if( not the_matching_diagnoses.empty? )
#binding.pry #cs
              the_symptom_string = the_framework_to_check[:fact_group].symptom_string_for(the_symptom_name)
              the_symptom_element = { :symptom_string => the_symptom_string, :associated_diagnostic_codes => the_matching_diagnoses }
              the_framework_to_check[:unattached_symptoms] << the_symptom_element
            end
          end
#binding.pry #cs
        #when -> (the_id) { the_id.starts_with?('diagnosis-') }
        when the_id.starts_with?('diagnosis-')
#binding.pry #cs
#          the_diagnosis_name = the_html_node_to_add['name'].partition('-').last
          the_diagnostic_code = the_html_node_to_add['value']
          @the_internal_framework.each do |the_framework_to_check|
            if( the_framework_to_check[:fact_group].contains(the_diagnostic_code) )
              the_diagnosis_string = the_framework_to_check[:fact_group].diagnosis_string_for(the_diagnostic_code)
              the_diagnosis_element = { :diagnosis_string => the_diagnosis_string, :diagnostic_code => the_diagnostic_code, :associated_symptoms => Array.new, :diagnosis_modifiers => Array.new }
              the_framework_to_check[:diagnoses] << the_diagnosis_element
            end
          end
#binding.pry #cs
        # when -> (the_id) { the_id.starts_with?('diagnosis_modifier-') }
        when the_id.starts_with?('diagnosis_modifier-')
            the_diagnostic_code = the_diagnosis_modifier_diagnosis_code_based_on( the_html_node_to_add['id'])
            the_diagnosis_modifier_name = the_diagnosis_modifier_name_based_on( the_html_node_to_add['id'])
#cs DEAP-1592            the_diagnosis_modifier_value = the_diagnosis_modifier_value_from(the_html_node_to_add)
            the_diagnosis_modifier_values = the_diagnosis_modifier_values_from(the_html_node_to_add)
          @the_internal_framework.each do |the_framework_to_check|
            if( the_framework_to_check[:fact_group].contains(the_diagnostic_code) )
              the_diagnosis_modifier_values.each do |the_diagnosis_modifier_value|   #cs DEAP-1592
                the_diagnosis_modifier_string = the_framework_to_check[:fact_group].diagnosis_modifier_string_for(the_diagnostic_code, the_diagnosis_modifier_name, the_diagnosis_modifier_value)
                the_diagnosis_modifier_fields = the_framework_to_check[:fact_group].diagnosis_modifier_fields_for(the_diagnostic_code ,the_diagnosis_modifier_name)
                the_diagnosis_modifier_element = {:diagnosis_modifier_string => the_diagnosis_modifier_string, :diagnosis_modifier_fields => the_diagnosis_modifier_fields, :diagnostic_code => the_diagnostic_code}
                the_framework_to_check[:unattached_diagnosis_modifiers] << the_diagnosis_modifier_element
              end  #cs DEAP-1592
#binding.pry #cs
            end
          end
      end
    end
  end
  
  def the_diagnosis_modifier_values_from(the_field)
    case the_field.name
      when 'select'
#binding.pry #cs
        the_value_array = []
        the_field.children.each do |the_option_to_check|
          if( the_option_to_check['selected'] == 'selected' )
#binding.pry #cs
            the_value_array << the_option_to_check['value']
          end
        end
#binding.pry #cs
        return the_value_array  # raise an exception
      else
        return [""]  # raise an exception
    end 
  end
  
  def the_diagnosis_modifier_value_from(the_field)
    case the_field.name
#      when 'input'
#        the_field_type = the_field_to_check['type']
#        case the_field_type
#          when 'checkbox'
#            return( the_field_to_check['checked'] == 'checked' )
#          when 'radio'
##binding.pry #cs
#            return( the_field_to_check['checked'] == 'checked' )
#          else
#            return false
#        end
      when 'select'
#binding.pry #cs
        the_field.children.each do |the_option_to_check|
          if( the_option_to_check['selected'] == 'selected' )
#binding.pry #cs
            return the_option_to_check['value']
          end
        end
#binding.pry #cs
        return ''  # raise an exception
#      when 'option'
#binding.pry #cs
#        return ( the_field_to_check['selected'] == 'selected' )
      else
        return '' # raise an exception
    end 
  end
  
  def the_diagnosis_modifier_name_based_on( the_diagnosis_modifier_id )
    the_stripped_id = the_diagnosis_modifier_id.split('-select').first
    the_name = the_stripped_id.split('-').second
    return the_name
  end
  
  def the_diagnosis_modifier_diagnosis_code_based_on( the_diagnosis_modifier_id )
    the_stripped_id = the_diagnosis_modifier_id.split('-select').first
    the_diagnostic_code = the_stripped_id.split('-').last
#binding.pry #cs
    return the_diagnostic_code
  end
  
  def consolidates_its_elements
    @the_internal_framework.each do |the_framework_to_consolidate|
      
      the_framework_to_consolidate[:unattached_symptoms].each do |the_symptom_to_move|
        the_symptom_has_been_attached = false
        the_framework_to_consolidate[:diagnoses].each do |the_diagnosis_to_check|
          if(the_symptom_to_move[:associated_diagnostic_codes].include?(the_diagnosis_to_check[:diagnostic_code]) )
            the_diagnosis_to_check[:associated_symptoms] << the_symptom_to_move
            the_symptom_has_been_attached = true
            break
          end
          break if the_symptom_has_been_attached
        end
        if( !the_symptom_has_been_attached )
#binding.pry #cs
          the_framework_to_consolidate[:diagnoses].first[:associated_symptoms] << the_symptom_to_move
        end
      end
      the_framework_to_consolidate[:unattached_symptoms] = Array.new
      
      the_framework_to_consolidate[:unattached_diagnosis_modifiers].each do |the_diagnosis_modifier_to_move|
#binding.pry #cs
        the_diagnosis_modifier_has_been_attached = false
        the_framework_to_consolidate[:diagnoses].each do |the_diagnosis_to_check|
          if(the_diagnosis_modifier_to_move[:diagnostic_code] == the_diagnosis_to_check[:diagnostic_code])
            the_diagnosis_to_check[:diagnosis_modifiers] << the_diagnosis_modifier_to_move
            the_diagnosis_modifier_has_been_attached = true
            break
          end
          break if the_diagnosis_modifier_has_been_attached
        end
      end
      the_framework_to_consolidate[:unattached_diagnosis_modifiers] = Array.new
    end
  end
  
  def xml_string(the_evaluation)
    the_concatenated_documents = '<ExamResponses>'
    self.exam_response_xml_documents(the_evaluation).each do |the_exam_response_to_add|
      the_concatenated_documents = the_concatenated_documents + the_exam_response_to_add
    end
    the_concatenated_documents = the_concatenated_documents + '</ExamResponses>'
    return the_concatenated_documents
  end
      
      
  def exam_response_xml_documents(the_evaluation)
#    return '<bogus>bogus</bogus>'
#binding.pry #cs 
    the_list_of_exam_response_elements = Array.new
    # go through the internal_framework
    @the_internal_framework.each do |the_framework_to_use|
    #   if the current fact group contains diagnoses
      if( not the_framework_to_use[:diagnoses].empty?)
    #     create an exam-response element
        the_exam_response_element = a_new_exam_response_element
        the_exam_response_element << a_new_document_type_version_element('4.0')
        the_exam_response_element << a_new_claim_id_element(the_evaluation.claim. vbms_claim_id)
    #     create a common-data element for the current fact group and add it to the exam-response element
        the_exam_response_element << a_new_common_data_element( the_framework_to_use )
    #     create a fact block for the current fact group
        the_fact_block = a_new_evaluation_data_element()
    #     for each diagnoses in the current fact group
        the_framework_to_use[:diagnoses].each do |the_diagnosis_to_use|
          
    #         create a fact element
          the_fact_element = a_new_fact_element(the_framework_to_use[:fact_group].namespace, the_framework_to_use[:fact_group].fact_block_tag_name)
    #         create a diagnosis element and add it to the fact element
          the_fact_element << a_new_diagnosis_element(the_framework_to_use[:fact_group].namespace,
                                                      the_framework_to_use[:fact_group].diagnosis_tag_name,
                                                      the_framework_to_use[:fact_group].diagnosis_string_for(the_diagnosis_to_use[:diagnostic_code]) )
    #         create the symptom elements and add them to the fact element
          the_diagnosis_to_use[:associated_symptoms].each do |the_symptom_to_use|
#binding.pry #cs
            the_fact_element << a_new_symptom_element(the_framework_to_use[:fact_group].namespace,
                                                      the_framework_to_use[:fact_group].symptom_tag_name,
                                                      the_framework_to_use[:fact_group].symptom_string_for(the_symptom_to_use[:symptom_string]) )
          end
    #         create the diagnosis-modifier elements and add them to the fact element TBD
#binding.pry #cs
          the_diagnosis_to_use[:diagnosis_modifiers].each do |the_diagnosis_modifier_to_use|
            the_fact_element << a_new_diagnosis_modifier_element( the_framework_to_use[:fact_group].namespace,
                                                                  the_diagnosis_modifier_to_use                 )
          end
    #         add the additional fields for the fact group to the fact element
          the_additional_fields_hash = eval(the_framework_to_use[:fact_group].additional_fields)
          the_additional_fields_hash.each do |the_field_name, the_field_value|
#binding.pry #cs
            the_fact_element << XmlGenerationUtilities.new_node_with_a_value( the_framework_to_use[:fact_group].namespace,
                                                                              the_field_name,
                                                                              the_field_value                   )
          end

    #         add the fact element to the fact block for the fact group
          the_fact_block << the_fact_element
    #     end for
        end
    #     add the fact block for the current fact group to the exam-response element
        the_exam_response_element << the_fact_block
    #     create an attachment element for the current fact group and add it to the exam-response element
        the_exam_response_element << a_new_attachments_element(the_evaluation)
    #     add the exam-response element to the list of exam-response elements
        the_list_of_exam_response_elements << the_exam_response_element
    #   end if
      end
    # end go
    end
  
#    the_aggregate_xml_string = '<bogus>bogus</bogus>'
    
    #the_aggregate_xml_array = Array.new
#    the_aggregate_xml_string = ""

    the_aggregate_exam_response_documents = Array.new
    
    the_list_of_exam_response_elements.each do |entry|
      the_aggregate_exam_response_documents << entry.to_xml
#       the_aggregate_xml_string = the_aggregate_xml_string + entry.to_xml
     
    end

    # FIX_ME : TBD: Find requirements for actual ExamResponse envelope : cs 2016-12-12 There are none; they should be sent separately
#    the_aggregate_xml_string = "<ExamResponses>" + the_aggregate_xml_string + "</ExamResponses>"
    
    #the_aggregate_xml_string = the_list_of_exam_response_elements.first.to_xml #cs TEMP
    # go through the list of exam-response elements, collecting
    #   add the xml string from the current exam-response element to the collection
    # end go
    # return the aggregate xml string
#binding.pry #cs

    return the_aggregate_exam_response_documents

#    return the_aggregate_xml_string
  end
    
    
private

  THE_LIST_OF_NAMESPACE_ATTRIBUTES =  { 'xmlns:xsi'     =>  'http://www.w3.org/2001/XMLSchema-instance',
                                        'xmlns:vler'    =>  'http://DNS   /vler/schemas/vlerSupersetSchema/0.9/vler',
                                        'xmlns:s'       =>  'http://niem.gov/niem/structures/2.0',
                                        'xmlns:nc'      =>  'http://niem.gov/niem/niem-core/2.0',
                                        'xmlns:cld'     =>  'http://vler.DNS   /vler/schemas/benefits/ExamResponse/4.0',
                                        'xmlns:bsf'     =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/BodySystemsFacts/1.1',
                                        'xmlns:ampf'    =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/AmputationFacts/1.2',
                                        'xmlns:ankf'    =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/AnkleFacts/1.2',
                                        'xmlns:acalcf'  =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/AudiometricsCalcForm/1.1',
                                        'xmlns:aaf'     =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/AuditoryAcuityFacts/1.1',
                                        'xmlns:cvf'     =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/CardiovascularFacts/1.2',
                                        'xmlns:cbsf'    =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/CommonBodySystemFacts/2.0',
                                        'xmlns:dentf'   =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/DentalFacts/1.1',
                                        'xmlns:digf'    =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/DigestiveFacts/1.2',
                                        'xmlns:eatdf'   =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/EatingDisorderFacts/1.1',
                                        'xmlns:elbf'    =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/ElbowFacts/1.3',
                                        'xmlns:endf'    =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/EndocrineFacts/1.2',
                                        'xmlns:eyef'    =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/EyeFacts/1.1',
                                        'xmlns:guf'     =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/GenitourinaryFacts/1.2',
                                        'xmlns:gyf'     =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/GynecologicalFacts/1.1',
                                        'xmlns:hf'      =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/HandFacts/1.1',
                                        'xmlns:hfnsfl'  =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/HeadFaceNeckScarFactsList/1.2',
                                        'xmlns:hl'      =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/HearingLoss/1.2',
                                        'xmlns:hlf'     =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/HemicLymphaticFacts/1.1',
                                        'xmlns:hif'     =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/HipFacts/1.3',
                                        'xmlns:kf'      =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/KneeFacts/1.2',
                                        'xmlns:mdf'     =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/MentalDisorderFacts/1.1.1',
                                        'xmlns:mf'      =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/MuscleFacts/1.1',
                                        'xmlns:msof'    =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/MusculoskeletalOtherFacts/1.3',
                                        'xmlns:nnfl'    =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/NeurologicalNervesFactsList/1.1',
                                        'xmlns:nof'     =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/NeurologicalOtherFacts/1.1',
                                        'xmlns:ntbif'   =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/NeurologicalTBIFacts/1.1',
                                        'xmlns:rf'      =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/RespiratoryFacts/1.1',
                                        'xmlns:setfl'   =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/ScarExtremitiesTrunkFactsList/1.2',
                                        'xmlns:shf'     =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/ShoulderFacts/1.3',
                                        'xmlns:skf'     =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/SkinFacts/1.1',
                                        'xmlns:spf'     =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/SpineFacts/1.3',
                                        'xmlns:tbif'    =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/TBIFacets/1.0',
                                        'xmlns:wf'      =>  'http://vler.DNS   /vler/schemas/benefits/evaluation/facts/WristFacts/1.3'                           }

  def a_new_diagnosis_modifier_element(the_namespace,the_diagnosis_modifier_field_info)
#binding.pry #cs
    the_outer_node = nil
    the_innermost_node = nil
    the_diagnosis_modifier_field_info[:diagnosis_modifier_fields].each do |the_field_to_add|
      the_innermost_node = XmlGenerationUtilities.new_node(the_namespace, the_field_to_add)
      if (the_outer_node.nil?)
        the_outer_node = the_innermost_node
      else
        the_outer_node << the_innermost_node
      end
    end
    the_innermost_node.content =the_diagnosis_modifier_field_info[:diagnosis_modifier_string] 
 #binding.pry #cs
    return the_outer_node
#    return XmlGenerationUtilities.new_node_with_a_value(the_namespace, the_diagnosis_modifier_field_info[:diagnosis_modifier_field], the_diagnosis_modifier_field_info[:diagnosis_modifier_string] )
  end

  def a_new_symptom_element(the_namespace, the_tag_name, the_value)
    the_new_symptom_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
    the_new_value_element = XmlGenerationUtilities.new_node(the_namespace, 'value')
    the_new_value_element.content=the_value
    the_new_symptom_element << the_new_value_element
    return the_new_symptom_element
  end

  def a_new_diagnosis_element(the_namespace, the_tag_name, the_value)
    the_new_diagnosis_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
    the_new_value_element = XmlGenerationUtilities.new_node(the_namespace, 'value')
    the_new_value_element.content=the_value
    the_new_diagnosis_element << the_new_value_element
    return the_new_diagnosis_element
  end

  def a_new_fact_element(the_namespace, the_tag_name)
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
    return the_new_element
  end



  def a_new_common_data_element( the_framework )
    the_document_type_element_values = 
    {
      creation_date:  {date: '2016-10-26', margin_of_error: 'P0Y0M0DT0H0M0S'},
      description:    {string: 'Full-Body Examination', partial_indicator: false}, # truncation_indicator(o): <Ruby boolean>}
      effective_date: {date: '2016-10-31', margin_of_error: 'P0Y0M2DT0H0M0S'},
      identification: {id: 'big incomprehensible number', jurisdiction: {string: 'all'}}, # partial_indicator(o): <Ruby boolean>, truncation_indicator(o): <Ruby boolean>},
      received_date:  {date:'2016-10-29'}, #margin_of_error(o): <string, PnYnMnDTnHnMnS>},
      status:         
      {
        status:      {string: 'active'}, # partial_indicator(o): <Ruby boolean>, truncation_indicator(o): <Ruby boolean>},
        date:        {date: '2016-10-31'}, # margin_of_error(o): <string, PnYnMnDTnHnMnS>},
        description: {string: 'Initial submission'}, # partial_indicator(o): <Ruby boolean>, truncation_indicator(o): <Ruby boolean>},
        issuer:      {string: 'CUI Application'}, # partial_indicator(o): <Ruby boolean>, truncation_indicator(o): <Ruby boolean>}
      },
      
      title:          {string: the_framework[:fact_group].document_title},
    }
    
    the_facility_type_element_values = 
    {
      contact_info:
      {
        means:                   'TBD11',
        entity:                  'TBD12',
        entity_description:      { string:'TBD13', partial_indicator: false, truncation_indicator: false},
        information_description: { string:'TBD14', partial_indicator: true},
        responder:               
        {
          name:
          {
            first:  {name: {text_info: {string: 'John'}}},
            middle: {name: {text_info: {string: 'J'}}, is_an_initial: true}, 
            last:   {name: {text_info: {string: 'Jingleheimer-Schmidt'}}, is_an_initial: false},
            suffix: {string: 'III'} 
          }
        }
      },
      location:       '123 Fourth Street, Anytown, Somestate, USA, 97531',
      is_commercial:  true,
      category:       {string: 'TBD7', truncation_indicator: false},
      name:           {text_info: {string: 'TBD9'}, form_code: 'TBD8'},
      identification: {id: 'TBD1', jurisdiction: {string: 'TBD2', partial_indicator: false, truncation_indicator: true} }
    }
    
    
    the_service_provider_client_association_type_element_values =
    {
      date_range:   { starting: {date: '1212-12-12'}, # margin_of_error(o): <string, PnYnMnDTnHnMnS>},
                      ending:   {date: '1960-03-15'} }, # margin_of_error(o): <string, PnYnMnDTnHnMnS>}    },
      provider:     {id: 'The Provider ID', ref: 'The Provider Reference', metadata: 'The Provider Metadata'},
      client:       {id: 'The Client ID', ref: 'The Client Reference', metadata: 'The Client Metadata'},
      is_active:    true
    }




    the_new_element = XmlGenerationUtilities.new_node('cld', 'CommonData')
    the_new_element << TheDocumentTypeElementGenerator.new_document_type_element('nc', 'Document', the_document_type_element_values)
    the_new_element << a_new_exam_detail_element('vler', 'ExamDetail')
    the_new_element << a_new_client_type_element('vler', 'Client')
    the_new_element << a_new_service_provider_type_element('vler', 'ServiceProvider')
    the_new_element << a_new_approver_type_element('vler', 'Approver')
    the_new_element << TheNiemCoreXmlElementGenerator.new_person_type_element('nc', 'Person', { name: { last: {name: {text_info: {string: 'TBD CLINICIAN'}}}, suffix: {string: 'MD'}}} ) #clinician
    the_new_element << TheNiemCoreXmlElementGenerator.new_person_type_element('nc', 'Person', { name: { last: {name: {text_info: {string: 'TBD VETERAN'}}}}} )                            #veteran
    the_new_element << TheFacilityTypeElementGenerator.new_facility_type_element('nc', 'Facility', the_facility_type_element_values)
    the_new_element << TheVlerXmlElementGenerator.new_service_provider_client_association_type_element('vler', 'ServiceProviderClientAssociation', the_service_provider_client_association_type_element_values)
    return the_new_element
  end
  
  def a_new_service_provider_client_association_type_element(the_namespace, the_tag_name, the_hash_of_values=nil)       #vler
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)

    return the_new_element
  end


  
  def a_new_approver_type_element(the_namespace, the_tag_name, the_hash_of_values=nil)                                  #vler
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)

    return the_new_element
  end


  
  def a_new_service_provider_type_element(the_namespace, the_tag_name, the_hash_of_values=nil)                          #vler
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)

    return the_new_element
  end


  
  def a_new_client_type_element(the_namespace, the_tag_name, the_hash_of_values=nil)                                    #vler
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)

    return the_new_element
  end


  
  def a_new_exam_detail_element(the_namespace, the_tag_name, the_hash_of_values=nil)                                    #vler
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)

    return the_new_element
  end



  
  def a_new_person_type_element(the_namespace, the_tag_name, the_hash_of_values=nil)                                    #nc
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
#cs = TheNiemCoreXmlElementGenerator.new_person_type_element

    return the_new_element
  end
  
  def a_new_clinician_element(the_namespace, the_tag_name)
    the_clinician_values = {name_info: {first_name: 'TBD1', last_name: 'TBD2'}}
    the_new_element = a_new_person_type_element(the_namespace, the_tag_name, the_clinician_values)
    return the_new_element
  end
  
  def a_new_veteran_element(the_namespace, the_tag_name)
    the_clinician_values = {name_info: {first_name: 'TBD1', last_name: 'TBD2'}, date_of_birth: 'TBD3', social_security_number: 'TBD4'}
    the_new_element = a_new_person_type_element(the_namespace, the_tag_name, the_clinician_values)
    return the_new_element
  end


  
  def a_new_document_type_element(the_namespace, the_tag_name)                                                      #nc
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
#          <xsd:element ref="nc:DocumentCreationDate" minOccurs="0" maxOccurs="5000"/>
#          <xsd:element ref="nc:DocumentDescriptionText" minOccurs="0" maxOccurs="5000"/>
#          <xsd:element ref="nc:DocumentEffectiveDate" minOccurs="0" maxOccurs="5000"/>
#          <xsd:element ref="nc:DocumentIdentification" minOccurs="0" maxOccurs="5000"/>
#          <xsd:element ref="nc:DocumentReceivedDate" minOccurs="0" maxOccurs="5000"/>
#          <xsd:element ref="nc:DocumentStatus" minOccurs="0" maxOccurs="5000"/>
#          <xsd:element ref="nc:DocumentTitleText" minOccurs="0" maxOccurs="5000"/>
    return the_new_element
  end

  def a_new_evaluation_data_element()
    the_new_element = XmlGenerationUtilities.new_node('cld', 'EvaluationData')
    return the_new_element
  end

  def a_new_attachments_element(the_evaluation_to_use)
    the_new_element = XmlGenerationUtilities.new_node('cld', 'Attachments')
    the_new_element << a_new_pdf_attached_document_node_containing(the_evaluation_to_use)
    the_new_element << a_new_text_attached_document_node_containing(the_evaluation_to_use)
    return the_new_element
  end
  
  def a_new_pdf_attached_document_node_containing(the_evaluation_to_use)
    return a_new_attached_document_node_based_on('nc', 'Attachment', the_evaluation_to_use.to_pdf, the_evaluation_to_use.pdf_file_name, "application/pdf" )    # the_new_element << create_attachment(the_evaluation_to_use.to_pdf, the_evalaution_to_use.pdf_path,  "application/pdf")
  end

  def a_new_text_attached_document_node_containing(the_evaluation_to_use)
    return a_new_attached_document_node_based_on('nc', 'Attachment', the_evaluation_to_use.to_text, the_evaluation_to_use.text_file_name, "text/plain" )
  end
  
  def a_new_attached_document_node_based_on(the_namespace, the_tag_name, the_content, the_file_name, the_file_format)
    the_attached_document_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
#binding.pry #cs
    the_attached_document_element << a_new_binary_base64_object_node(the_namespace, 'BinaryBase64Object', the_content)
    the_attached_document_element << a_new_binary_location_uri_node(the_namespace, 'BinaryFormatStandardName', the_file_name)
    the_attached_document_element << a_new_binary_format_node(the_namespace, 'BinaryFormatStandardName', the_file_format)
    return the_attached_document_element
  end
  
  def a_new_binary_base64_object_node(the_namespace, the_tag_name, the_content_to_encode)
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
    the_new_element.content = Base64.encode64(the_content_to_encode)
    return the_new_element
  end

  def a_new_binary_location_uri_node(the_namespace, the_tag_name, the_uri)
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
    the_new_element.content = the_uri
    return the_new_element
  end

  def a_new_binary_format_node(the_namespace, the_tag_name, the_format)
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
    the_new_element.content = the_format
    return the_new_element
  end


  def a_new_claim_id_element(the_claim_id)
    the_new_element = XmlGenerationUtilities.new_node('cld', 'ClaimID')
    the_new_element.content=the_claim_id
    return the_new_element
  end

  def a_new_document_type_version_element(the_version_string)
    the_new_element = XmlGenerationUtilities.new_node('cld', 'DocumentTypeVersion')
    the_new_element.content=the_version_string
    return the_new_element
  end

  def a_new_exam_response_element
    the_new_element = XmlGenerationUtilities.new_node('cld', 'ExamResponse')
    THE_LIST_OF_NAMESPACE_ATTRIBUTES.each do |the_namespace_id, the_namespace_uri|
      the_new_element.set_attribute(the_namespace_id, the_namespace_uri)
    end
#    the_new_element.set_attribute('xmlns:xsi','"http://www.w3.org/2001/XMLSchema-instance"')
    return the_new_element
  end

##  def a_new_xml_node(the_namespace, the_node_name, the_document=Nokogiri::XML::Document.new)
####    the_new_node = Nokogiri::XML::Node.new("#{the_namespace}:#{the_node_name}", the_document)
##    the_new_node = Nokogiri::XML::Node.new(the_namespace + ':' + the_node_name, the_document)
##    return the_new_node
##  end

  def a_new_body_facts_node(the_node_name, the_document=document)
    return XmlGenerationUtilities.new_node('cld', the_node_name, the_document)
  end
  
  def add_a_child_at_the_beginning_of_a_node(the_parent_node, the_node_to_add)
    the_parent_node.prepend_child(the_node_to_add)
  end


end
