# == Schema Information
#
# Table name: notifications
#
#  id         :integer          not null, primary key
#  created_at :datetime         not null
#  updated_at :datetime         not null
#

# SMELL: This model does not seem to be used in the code and should probably be removed

class ExamRequestAcknowledgementNotification < Notification

  def build_notification(orig_notification_doc, req_object_doc, site)
    # Get the template document for the acknowledement notification
    template_path = File.join(Rails.root.to_s, 'app', 'xml', 'templates', 'exam_request_acknowledgement_template.xml')
    acknowledge_doc = Nokogiri::XML(File.open(template_path))

    eventId = SecureRandom.uuid

    # Copy OriginatingSystem Node into exam request acknowledgement doc
    ac_origin_sys = XmlHelper.getDoc(acknowledge_doc, 'OriginatingSystem')
    ac_origin_sys['contractorName'] = site.name
    
    # Copy ExamRequestAcknowledgementEvent Node from request object doc into exam request acknowledgement doc
    ac_erae = XmlHelper.getDoc(acknowledge_doc, 'ExamRequestAcknowledgementEvent')
    ro_erae = XmlHelper.getDoc(req_object_doc, 'ExamRequestAcknowledgementEvent')
    ro_erae_clone = ro_erae.clone
    prev_event = get_prev_event_id orig_notification_doc
    ro_erae_clone['previousEvent'] = prev_event
    ro_erae_clone['eventId'] = eventId
    ro_erae_clone['eventDtg'] = Time.now.utc.iso8601
    
    ac_erae.replace ro_erae_clone
    
    ac_event_source = XmlHelper.getDoc(ac_erae, 'EventSource')
    ac_event_source['participatingSystemName'] = "VBA Contractor"
    ac_event_source['contractorName'] = site.name
    
    @document = acknowledge_doc
    return eventId

    # Now acknowledge_doc is ready to be sent as xml to DAS

  end

  #handles regular exam request and reworked exam request
  def get_prev_event_id orig_notification_doc
    event = XmlHelper.getDoc(orig_notification_doc, 'ExamSchedulingRequestCreatedEvent')
    return event.attributes["eventId"].value unless event.nil?
    XmlHelper.getDoc(orig_notification_doc, 'ReworkedExamSchedulingRequestCreatedEvent').attributes["eventId"].value
  end

end
