# == Schema Information
#
# Table name: diagnosis_codes
#
#  id           :integer          not null, primary key
#  version_code :string           not null
#  description  :string           not null
#  deleted_at   :datetime
#

class DiagnosisCode < ActiveRecord::Base

  acts_as_paranoid

  def version
    version = version_code[0,2]
  end

  def chapter
    chapter = version_code[2,3]
  end

  def code
    code =  version_code[2,6]
  end

  class << self

    # Validate a list of codes in a string that are either space, comma
    # or both separated.  Return a string that contains invalid codes
    # separated by ', '
    #
    # An empty return string means all codes were valid.

    def validate_codes(a_string='')
      return '' if a_string.nil? || a_string.empty?

      codes   = a_string.gsub(',', ' ').upcase.split(' ')
      codes.select {|code| self.find_by_version_code(code).nil?}.join(', ')
    end
  end
end
