## == Schema DbqInformation
#
#  Table name: dbq_informations
#  identifier            :string
#  title                 :string
#  created_at            :datetime         not null
#  updated_at            :datetime         not null

class DbqInformation < ActiveRecord::Base
  has_many  :boilerplate_messages, through: :boilerplate_messages_dbq_informations
  has_many  :boilerplate_messages_dbq_informations, dependent: :destroy
  has_many  :contentions, through: :contentions_dbq_informations
  has_many  :contentions_dbq_informations, dependent: :destroy
  has_many  :symptoms, through: :symptoms_dbq_informations
  has_many  :symptoms_dbq_informations, dependent: :destroy
  has_many  :diagnoses, through: :diagnoses_dbq_informations
  has_many  :diagnoses_dbq_informations, dependent: :destroy
  has_many  :general_questions, through: :general_questions_dbq_informations
  has_many  :general_questions_dbq_informations, dependent: :destroy

  validates :identifier, :title, presence: true

  def creates_a_unique_boilerplate_message_association_with(the_boilerplate_message_to_use)
    unless boilerplate_messages.include? the_boilerplate_message_to_use
      boilerplate_messages << the_boilerplate_message_to_use
    end
  end

  def creates_a_unique_contention_association_with(the_contention_to_use)
    unless contentions.include? the_contention_to_use
      contentions << the_contention_to_use
    end
  end

  def creates_a_unique_symptom_association_with(symptom_to_use)
    unless symptoms.include? symptom_to_use
      symptoms << symptom_to_use
    end
  end

  def creates_a_unique_diagnosis_association_with(diagnosis_to_use)
    unless diagnoses.include? diagnosis_to_use
      diagnoses << diagnosis_to_use
    end
  end

  def creates_a_unique_gq_association_with(gq_to_use)
    unless general_questions.include? gq_to_use
      general_questions << gq_to_use
    end
  end

  def gq_dbq_info_order_asc
    general_questions_dbq_informations.order("position ASC")
  end

  def diagnoses_dbq_info_order_asc
    diagnoses_dbq_informations.order("position ASC")
  end

  def symptoms_dbq_info_order_asc
    symptoms_dbq_informations.order("position ASC")
  end

end
