# == Schema Information
#
# Table name: clinics
#
#  id         :integer          not null, primary key
#  site_id    :integer
#  clinic_id  :integer
#  name       :string
#  created_at :datetime         not null
#  updated_at :datetime         not null
#  deleted_at :datetime
#

# NOTE:  The column name "clinic_id" is not a database reference; rather it is
#        an identifer used by Vista in its appointment scheduling services.  A
#        better name for the variabler would be "clinic_identifier"

# NOTE:  The same thing _MAY_ be true for site_id - that it is really a 
#        sote identifier and not a reference to the Site model.

class Clinic < ActiveRecord::Base
  acts_as_paranoid
  
  # Class Methods
  class << self

    # Get clinic id from user passed, using user preferences to get site.
    # NOTE: Currently sites have only one clinic.  This functionality will
    # change if we allow sites (facilities in VISTA) to have multiple clinics.
    def get_clinic_from_user(user)
      if user.is_vha_cc?
        site_id = user.user_preference.vista_site_id
        Clinic.where(site_id: site_id).first
      end
    end

  end

end
