# == Schema Information
#
# Table name: notifications
#
#  id         :integer          not null, primary key
#  created_at :datetime         not null
#  updated_at :datetime         not null
#

class ClarificationRequestEvent < Notification

  def build_notification(claim_id, site_id, user, clarificationRequest)
    path = File.join(Rails.root.to_s, 'app', 'xml', 'templates', 'clarification_request_event.xml')
    @document = Nokogiri::XML(File.open(path))

    clarificationRequestEvent = XmlHelper.getDoc(@document, 'ClarificationRequestEvent')

    requestObject = RequestObject.all.order('created_at desc').find_by_claim_id claim_id
    request_object_doc = Nokogiri::XML(requestObject.xml)

    site = Site.find_by_id(site_id)
    if (site == nil)
      raise Exception, "Invalid site id ::: " + site_id
    end
    
    originatingSystemTag = XmlHelper.getDoc(@document, 'OriginatingSystem')
    originatingSystemTag['contractorName'] = site.name

    examSchedulingRequestCreatedEvent = XmlHelper.getDoc(request_object_doc, 'ExamSchedulingRequestCreatedEvent')
    
    eventId = SecureRandom.uuid
    clarificationRequestEvent['eventId'] = SecureRandom.uuid
    clarificationRequestEvent['previousEvent'] = examSchedulingRequestCreatedEvent['eventId']
    clarificationRequestEvent['eventDtg'] = Time.now.utc.iso8601
    clarificationRequestEvent['examSchedulingRequestId'] = examSchedulingRequestCreatedEvent['examSchedulingRequestId']
    clarificationRequestEvent['dateOfRequest'] = Date.today.to_s
    clarificationRequestEvent['modelVersion'] = "1.0"
    clarificationRequestEvent['createdByUser'] = user.first_name + " " + user.last_name

    clarificationReasonTag = XmlHelper.getDoc(clarificationRequestEvent, 'ClarificationReason')
    clarificationReasonTag.content = clarificationRequest.clarificationReason

    pocPhoneTag = XmlHelper.getDoc(clarificationRequestEvent, 'PointOfContactPhone')
    pocPhoneTag['primaryPhone'] = clarificationRequest.primary
    pocPhoneTag['alternatePhone'] = clarificationRequest.alternate
   
    contentionClarificationInfo = clarificationRequest.clarificationText 
    if (contentionClarificationInfo != nil && contentionClarificationInfo.length > 0)
      unclearContentionReferencesTag = XmlHelper.createTag(document, "UnclearContentionReferences")
      
      contentionClarificationInfo.each do |key, value|
        contentionClarificationRequestTag = XmlHelper.createTag(document, "ContentionClarificationRequest")
        contentionClarificationRequestTag['contentionUuid'] = key
        
        contentionClarificationFreeTextTag = XmlHelper.createTag(document, "ContentionClarificationFreeText")
        contentionClarificationFreeTextTag.content = value

        contentionClarificationRequestTag << contentionClarificationFreeTextTag

        unclearContentionReferencesTag << contentionClarificationRequestTag
      end
      clarificationRequestEvent << unclearContentionReferencesTag
    end
    @document.root << clarificationRequestEvent
    
    return eventId
  end
end

