module ReferralDocumentsHelper
  include ApplicationHelper
  include ActionView::Helpers::FormTagHelper


  # RWP TEMP: keeping approve + reject option in case the VHA Lead/Triage role can delete
  def approve_or_delete_link(referral, referral_doc)
    case referral_doc.visible_action_links(current_user)
    when :approve
      link_to('Approve', referral_referral_document_approve_path(referral, referral_doc),
        data: confirm_dialog_opts(:approve, referral_doc), method: :put)
    when :delete_own_documents
      button_tag 'Delete', class: 'text-button deleteRefDoc', type: 'button', data: {referral_doc_id: referral_doc.id}
    end
  end

  # Displays Reviewed By field as either checkbox or date reviewed
  def reviewed_by_field(referral_doc, user)
    has_been_reviewed = referral_doc.approved? && referral_doc.approver_name.present?
    if user.is_non_vha?
      if has_been_reviewed
        "#{referral_doc.approver_name} <br /> #{formatted_datetime(referral_doc.approved_at, user)}".html_safe
      else
        # To get rid of 508 violation (Ensure that each table header in a data table refers to data cells)
        "Waiting For Review"
      end
    elsif user.is_vha_cc?
      data_obj = {:'referral-id' => referral_doc.referral.id, :'doc-id' => referral_doc.id}
      check_box_tag('approvalChk[]_' + referral_doc.id.to_s, false, has_been_reviewed, class: :'approval-checkbox', data: data_obj) +label_tag('approvalChk[]_' + referral_doc.id.to_s, 'Reviewed').html_safe
    end
  end

private

  def confirm_dialog_opts(action_verb, referral_doc)
    {confirm: "Do you wish to #{action_verb} document '#{referral_doc.document_name}'?"}
  end

end
