module ReferralAppointmentsHelper
  #include ActionView::Helpers::FormTagHelper #is it a windows problem? In development sometimes the 'include ApplicationHelper' (below) is not sufficient to mixin 'submit_tag', force the issue by uncommenting.
  include ApplicationHelper

  # Displays Reviewed By field as either checkbox or date reviewed
  def created_in_cprs_datacell_html(referral_appointment, user)
    if referral_appointment.added_to_cprs?
      "#{referral_appointment.added_to_cprs_username} <br /> #{formatted_datetime(referral_appointment.added_to_cprs_at, user)}".html_safe
    else
      data_obj = {:'referral-id' => referral_appointment.referral.id, :'appointment-id' => referral_appointment.id}
      checkbox_html = submit_tag('Approve', class: 'usa-button cprs-approve-button', data: data_obj)
    end
  end

  def format_appointment_datetime(time)
    time.strftime('%-m/%-d/%Y %l:%M %p')
  end

end
