class UserCppController < ApplicationController
  skip_before_filter :authenticate_user!, :only => [:cpp_sign_in]
  skip_before_filter :authenticate_user_and_handle_cookies, :only => [:cpp_sign_in]

  def cpp_sign_in
    if current_user.present?
      redirect_to root_path
    end
  end

  def vista

  end

  # Action used by CPP and CUI. CUI uses this for vista login and requires the redirect to dashboards_path
  def vista_details
    begin
      vista_session = VIA_API.authenticate(via_login_params) # via_login paramaters is a hash with the keys: [:duz, :user_name, :site_id]
      Rails.logger.info "TEST vista_session = #{vista_session}"
      session[:vista] = vista_session
      current_user.user_preference.save_vista_session(vista_session)
      if current_user.is_cpp_user?
        redirect_to referrals_path
      else
        redirect_to dashboards_path
      end
    rescue VIA_API::ViaApiError => e
      flash[:alert] = e.to_s
      redirect_to root_path
    end
  end

  def via_login_params
    params.permit(:site_code, :verify_code, :access_code)
  end

end
