class QmAssignmentsController < ApplicationController
  include ContentManagerHelper
  include DataTablePaginator
  before_action :set_qm_assignment, only: [:create, :show, :edit, :update, :destroy]

  # GET /qm_assignments
  # GET /qm_assignments.json
  def index
    @qm_assignments = QmAssignment.all
  end

  # GET /qm_assignments/1
  # GET /qm_assignments/1.json
  def show
    if params[:delete_general_question_id].present?
      d = @question_modifier.general_questions.find_by_id(params[:delete_general_question_id])
      @question_modifier.general_questions.delete(d)
      flash.now[:notice] = "Question successfully removed."
    end
  end

  # GET /qm_assignments/new
  def new
    @qm_assignment = QmAssignment.new
    @general_question = GeneralQuestion.find(params[:general_question_id])
    @question_modifier = QuestionModifier.find(params[:question_modifier_id])
  end

  # GET /qm_assignments/1/edit
  def edit
    if params[:delete_general_question_id].present?
      d = @question_modifier.general_questions.find_by_id(params[:delete_general_question_id])
      @question_modifier.general_questions.delete(d)
      flash.now[:notice] = "Question successfully removed."
    end
  end

  # POST /qm_assignments/1/negative_show_check
  # Handles ajax call when user clicks on check boxes on the general_questions/id/edit page.
  def negative_show_check
    if qm = QmAssignment.find(params[:id])
      @general_question = GeneralQuestion.find(params[:general_question_id])
      params[:state] == "Yes" ? qm.negative_show = false : qm.negative_show = true
      qm.save
      respond_to do |format|
        format.js {}
      end
    end
  end

  # POST /qm_assignments
  # POST /qm_assignments.json
  def create
    @qm_assignment = QmAssignment.new(qm_assignment_params)

    respond_to do |format|
      if @qm_assignment.save
        update_qm_assignment_associations
        format.html { redirect_to [@general_question, @question_modifier, @qm_assignment], notice: 'New QM Assignment successfully added.' }
        format.json { render action: 'show', status: :created, location: general_question_question_modifier_qm_assignment_path(@general_question, @question_modifier, @qm_assignment) }
      else
        format.html { render action: 'new' }
        format.json { render json: @qm_assignment.errors, status: :unprocessable_entity }
      end
    end
  end

  # PATCH/PUT /qm_assignments/1
  # PATCH/PUT /qm_assignments/1.json
  def update
    respond_to do |format|
      if @qm_assignment.update(qm_assignment_params)
        format.html {
          if params[:qm_assignment][:prev_url]
            redirect_to params[:qm_assignment][:prev_url], notice: 'QM Assignment successfully updated.'
          else
            redirect_to edit_general_question_question_modifier_qm_assignment_path(@qm_assignment.get_general_question, @qm_assignment.get_question_modifier, @qm_assignment), notice: 'QM Assignment successfully updated.'
          end
        }
        format.json { head :no_content }
      else
        format.html { render action: 'edit' }
        format.json { render json: @qm_assignment.errors, status: :unprocessable_entity }
      end
    end
  end

  # DELETE /qm_assignments/1
  # DELETE /qm_assignments/1.json
  def destroy
    @qm_assignment.destroy
    respond_to do |format|
      format.html { redirect_to :back }
      format.json { head :no_content }
    end
  end

  def paged_list
    qm_assignment_to_fields_func = -> (qm_assignment) do
      general_question = qm_assignment.get_general_question
      question_modifier = qm_assignment.get_question_modifier
      {
        id:                       qm_assignment.id,
        name:                     qm_assignment.name.try(:humanize),
        row_label:                qm_assignment.label.try(:humanize),
        qma_general_question:     general_question.name.try(:humanize),
        qma_question_modifier:    question_modifier.name.try(:humanize),
        mod_type:                 question_modifier.mod_type,
        edit:                     edit_general_question_question_modifier_qm_assignment_path(general_question, question_modifier, qm_assignment),
        destroy:                  general_question_question_modifier_qm_assignment_path(general_question, question_modifier, qm_assignment)
      }
    end
    ordered_qm_assignments = apply_ordering_to_query(QmAssignment.filter(params), QmAssignment::FIELDS_FOR_RESULTSET, params['order'])
    json_user_data = paginate_with_params(ordered_qm_assignments).includes(:general_question, :question_modifier).map {|u| qm_assignment_to_fields_func.call(u) }
    total_record_count = ordered_qm_assignments.count
    render json: {
      draw: params[:draw].to_i,
      recordsTotal: total_record_count,
      recordsFiltered: total_record_count,
      data: json_user_data
    }
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_qm_assignment
      @qm_assignment = (QmAssignment.find(params[:id]) rescue nil)
      @general_question = GeneralQuestion.find(params[:general_question_id])
      @question_modifier = QuestionModifier.find(params[:question_modifier_id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def qm_assignment_params
      params.require(:qm_assignment).permit(:label, :negative_show, :exam_response_fields)
    end

    def update_qm_assignment_associations
      @qm_assignment.general_question = @general_question
      @qm_assignment.question_modifier = @question_modifier
      @qm_assignment.save
    end

end
