module PointlessFeedback
  class MessagesController < PointlessFeedback.parent_controller.constantize

    helper PointlessFeedback::ApplicationHelper

    def new
      @message = Message.new
    end

    def create
      @message = Message.new(message_params)
      @message.user = current_user
      @message.request_data = {
        remote_ip:  request.remote_ip,
        user_agent: request.user_agent,
        referrer:   request.referrer    # FIXME: always returns /feedback
      }

      if pass_captcha? && @message.save
        flash[:notice] = I18n.t('pointless_feedback.messages.saved',
                                :default => 'Thanks for your feedback!')
        redirect_to :back
      else
        render :new
      end
    end

    def index
      @messages = Message.all.order(created_at: :desc)

      respond_to do |format|
        format.html
      end
    end


    private

    def message_params
      params.require(:message).permit([
        :description,
        :email_address,
        :name,
        :topic,
        :contact_info
      ])
    end

    def pass_captcha?
      if PointlessFeedback.using_captcha?
        PointlessFeedback::Captcha.pass?(params["g-recaptcha-response"])
      else
        true
      end
    end

  end # class MessagesController < PointlessFeedback.parent_controller.constantize
end # module PointlessFeedback
