module ExamRequestUtility
  extend ActiveSupport::Concern

  # Method creates data to display full exam request message
  # Output is @long_view_data for the shared/_exam_request_long.html.haml
  def prepareDataForFullExamRequest(exam_request)
    request_object = RequestObject.find_by_claim_id exam_request.claim_id
    ro_hash = Hash.from_xml(request_object.xml).deep_symbolize_keys!
    @claim_information = ro_hash[:ExamSchedulingRequest][:ClaimInformation]
    @veteran_service_member_info = @claim_information[:VeteranServiceMemberInfo]
    @periods_of_service = @veteran_service_member_info[:PeriodsOfService][:Period]
    @pos_list = array_of_hashes(@periods_of_service)

    @preferred_geo_location = @veteran_service_member_info[:PreferredGeographicLocation]
    @contentions = ro_hash[:ExamSchedulingRequest][:Contentions][:ExamRelatedContention]
    @contention_list = array_of_hashes(@contentions)

    @ro = @veteran_service_member_info[:RegionalOffice]
    @ro_physical_add = @veteran_service_member_info[:RegionalOffice][:PhysicalAddress]
    @ro_mailing_add = @veteran_service_member_info[:RegionalOffice][:MailingAddress]
    @long_view_data = {
      :claim_information => @claim_information, :veteran_service_member_info => @veteran_service_member_info,
      :preferred_geo_location => @preferred_geo_location, :pos_list => @pos_list,
      :ro_physical_add => @ro_physical_add, :ro_mailing_add => @ro_mailing_add,
      :ro => @ro, :contention_list => @contention_list
    }
  end

  private
  def array_of_hashes val
    if val.is_a? Hash
      [ val ]
    elsif val.is_a? Array
      val
    elsif val.nil?
      []
    end
  end
end