// Place all the behaviors and hooks related to the matching controller here.
// All this logic will automatically be available in application.js.

function referral_documents_jqdr() {
    var oRefDocsTable = $('table#referralDocumentsTable').DataTable( {
        bLengthChange: false,
        bFilter: false,
        bSort: true,
        searching: false,
        aaSorting: [],
        aoColumnDefs: [{
            bSortable: false,
            aTargets: [5]
        }],
        pageLength: 10
    });

    var oReferralDocumentsDeletedTable = $('table#referralDocumentsDeletedTable').DataTable( {
        bLengthChange: false,
        bFilter: false,
        bSort: true,
        searching: false,
        aaSorting: [],
        pageLength: 5,
        columns:     [
            { title: 'File Name', data: 'document_link', orderable: true },
            { title: 'Document Type', data: 'doc_type_name', orderable: true },
            { title: 'Uploaded By', data: 'uploader_name', orderable: true },
            { title: 'Deleted By', data: 'deleted_by', orderable: true },
            { title: 'Deleted Date', data: 'formatted_deleted_at', orderable: true }
        ]
    });

    var deleteDocumentModal = $('div#deleteDocumentModal');

    oRefDocsTable.on('click', 'button.deleteRefDoc', function() {
        var data = oRefDocsTable.row( $(this).parents('tr') ).data();
        var ref_doc_id = $(this).data('referral-doc-id');
        $('span#del_doc_data').text(ref_doc_id);
        $('span#del_filename').html(data[0]);
        $('#delete_doc_reason').val('');
        $('#reason_validation_error').hide();
        deleteDocumentModal.foundation('reveal', 'open');
    });

    $('#doc-delete-delete-button').on('click', function(){
        var doc_id = $('span#del_doc_data').text();
        var reason = $('#delete_doc_reason').val();

        if (reason.length > 0) {
            $.post('/delete_referral_doc', {referral_doc_id: doc_id, reason: reason}, function (data) {
                if (data.success === true) {
                    oRefDocsTable.row('#tr_refdoc_' + doc_id).remove().draw();
                    closeModal(deleteDocumentModal);
                    addDeletedRefDocData(doc_id);
                } else {
                    $("span#reason_validation_error").text(data.msg).show();
                }
            });
        } else {
            $("span#reason_validation_error").show();
            $('#delete_doc_reason').focus();
        }
    });

    //toggle delete button visibility based on the hiding and showing of the inline edit
    $('.inline_edit')
        .on('show', function() {
            toggleDeleteBtn(this, 'hide');
        })
        .on('hide', function() {
            toggleDeleteBtn(this, 'show');
        });

    function addDeletedRefDocData(ref_doc_id) {
        $.get("/deleted_referral_docs_for_user", {referral_doc_id: ref_doc_id}, function(data) {
            //add the rows in and re-sort the table to have the most recent deleted document as the first record
            oReferralDocumentsDeletedTable.rows.add(data).draw(false);
            oReferralDocumentsDeletedTable.order([4, 'desc']).draw();
            oReferralDocumentsDeletedTable.page('first').draw(false);

            // open the deleted documents table if it is not visible based on the toggle image
            if ($('i#toggleDeletedData').hasClass('fa-plus-square')) {
                $('i#toggleDeletedData').click();
            }
        });
    }

    function toggleDeleteBtn(inline_edit, action) {
        var ref_doc_id = $(inline_edit).data('referral-doc-id');
        var delete_btn = $("button.deleteRefDoc[data-referral-doc-id='" + ref_doc_id + "']");

        if (delete_btn !== undefined) {
            if (action === 'show') {
                delete_btn.show();
            } else {
                delete_btn.hide();
            }
        }
    }

    $('i#toggleDeletedData')
      .on('keydown', function (e) {
        switch(e.keyCode) {
          case 13: //enter
          case 32: //spacebar
            // toggle the datatable visibility via the mouse click event
            this.click();
            break;
          case 9: //tab - allow focus to move off of the image
            break;
          default:
            return false;
        }
      })
      .on('click', function() {
        if ($(this).hasClass('initialize')) {
          $.get("/deleted_referral_docs_for_user", {referral_id: $(this).data('referral-id')}, function(data) {
            oReferralDocumentsDeletedTable.clear();
            oReferralDocumentsDeletedTable.rows.add(data).draw()
          });
        }

        var hide = $(this).hasClass('fa-minus-square');
        var img = hide ? 'fa fa-plus-square' : 'fa fa-minus-square'
        $('.deleted_rows').fadeToggle('slow', 'linear');
        $(this).removeClass().addClass(img);
    }).click();

    //--------------------------------------------------------------------------------
    $('input[type=file].referralDocUploader').hide();


    $('button.referralDocUploader').click(function () {
        $('input.referralDocUploader').trigger('click');
        return false;
    });

    $('input.referralDocUploader').change(function (e) {
        var fileObj = e.target.files[0];
        $('input[type=text].docNameField').val(fileObj.name)
    });

    $('.viewmore_vha').click(function () {
        var $this = $(this);
        $this.toggleClass('viewmore_vha');
        if ($this.hasClass('viewmore_vha')) {
            $this.text('View More...');
            $('.hidecontent_vha').hide();
        } else {
            $this.text('View Less...');
            $('.hidecontent_vha').show();
        }
    });

    $('.viewmore_cp').click(function () {
        var $this = $(this);
        $this.toggleClass('viewmore_cp');
        if ($this.hasClass('viewmore_cp')) {
            $this.text('View More...');
            $('.hidecontent_cp').hide();
        } else {
            $this.text('View Less...');
            $('.hidecontent_cp').show();
        }
    });

    $('table#referralDocumentsTable.data-table.inline-editable').each(function () {
        $(this).inlineEditable({
            savePutURL: inlineEditSaveUrl

        });
    });

    // handle ajax event when user clicks on Reviewed checkbox, and replaces checkbox
    // with approver and datestamp if successful.
    var $documentsTable = $('#referralDocumentsTable');
    $documentsTable.on('change', 'input.approval-checkbox', function (e) {
        if (e.target && e.target.checked === true) {
            var $checkbox = $(e.target);
            var referralId = parseInt($checkbox.data('referral-id'));
            var docId = parseInt($checkbox.data('doc-id'));
            if (!isNaN(referralId) && !isNaN(docId)) {
                $.ajax({
                    type: "PUT",
                    url: "/referrals/" + referralId + "/referral_documents/" + docId + "/approve.json",
                    contentType: 'json'
                }).done(function (data) {
                    $checkbox.closest('td').html(data.reviewed_by).effect("highlight", {color: 'green'}, 1000);
                    $('#header').after('<div class="alerts alert-box success animated fadeIn" id="reviewed_document"><div class="row"><div class="small-12 columns">Document was successfully reviewed.</div></div></div>');
                    $('#reviewed_document').fadeOut(10000);
                    window.scrollTo(0,0);
                }).fail(function (jqXHR) {
                    $checkbox.prop('checked', false);
                    $checkbox.closest('td').effect("highlight", {color: 'red'}, 1000);
                    $('#header').after('<div class="alerts alert-box alert animated fadeIn" id="failed_to_review_document"><div class="row"><div class="small-12 columns">Failed to review document.</div></div></div>');
                    $('#failed_to_review_document').fadeOut(10000);
                    window.scrollTo(0,0);
                });
            }
        }
    });


    function inlineEditSaveUrl(saveButton) {
        var referralId = $(saveButton).data("referral-id");
        var documentId = $(saveButton).data("referral-document-id");
        return "/referrals/" + referralId + "/referral_documents/" + documentId + ".json";
    }

    $documentsTable.creatableDataTable('#referralDocumentsForm.creatable-target');


    $("form#referralDocumentsForm").submit(function (e) {
        if ($('#referral_document_referral_document_type_id').val() == "") {
            e.preventDefault();
            $('#header').after('<div class="alerts alert-box alert animated fadeIn" id="invalid_referral_doc"> <div class="row"> <div class="small-12 columns"><span>Please select a Document Type.</div> </div> </div>');
            $('#invalid_referral_doc').fadeOut(10000);
            window.scrollTo(0, 0);
        }
    });
}