// Place all the behaviors and hooks related to the matching controller here.
// All this logic will automatically be available in application.js.

function question_modifiers_jqdr() {

  function getQuestionModifiersHeaders() {
    return [
      {data: "name", render: function(data) {
          if (data.length > 100)
            return (data.slice(0,100) + "\n" + data.slice(100, data.length));
          return data;
        },
        width: "20%", targets: 0
      },
      {data: "row_label", width: "20%", targets: 1},
      {data: "mod_type", width: "10%", targets: 2},
      {data: "list_values", render: function(data) {
          return data.join(", \n");
        },
        targets: 3
      },
      {data: "edit", render: function(data) {
          return "<a href=\"" + data +"\" class='fa fa-pencil-square-o fa-lg' title='edit'></a>";
        },
        targets: 4, searchable: false, orderable: false
      },
      {data: "destroy", render: function(data) {
          return "<a data-method=\"delete\" data-confirm=\"Are you sure?\" class='fa fa-trash-o fa-lg' title='delete' href=\"" + data +"\" ></a>";
        },
        targets: 5, searchable: false, orderable: false
      }
    ];
  }

  $("#question-modifier-index-table").DataTable({
    language: {
      lengthMenu: "Display _MENU_ Records",
      info: "Showing page _PAGE_ of _PAGES_ from a total of _MAX_ records"
    },
    columns: getQuestionModifiersHeaders(),
    ajax: '/question_modifiers/paged_list',
    processing: true,
    language: {
      processing: "<div><i class='fa fa-cog fa-2x fa-spin'></i></div>"
    },
    serverSide: true,
    pageLength: 25,
    columnDefs: [
        {"className": "name", "targets": [0]},
        {"className": "row_label", "targets": [1]},
        {"className": "mod_type", "targets": [2]},
        {"className": "list_values", "targets": [3]},
        {"className": "edit td-data-center", "targets": [4]},
        {"className": "destroy td-data-center", "targets": [5]}
      ],
    createdRow: function ( row, data, dataIndex ) {
      $(row).children('td').each (function(){
        var className = $(this).attr('class').replace('td-data-center','').trim();
        $(this).attr('headers', className);
      });
    }
  });

  $("form.edit_question_modifier #question_modifier_general_question_ids").chosen({
    placeholder_text_multiple: "Existing General Questions",
    search_contains: true
  });
}
