// Place all the behaviors and hooks related to the matching controller here.
// All this logic will automatically be available in application.js.

function showCancellationDetails(name, numberOfExaminations, reasonForCancellation, cancellationDetails) {
  //alert(name);
  $("#contentionName").html(name);
  $("#examinations").html(numberOfExaminations);
  $("#reasonForCancellation").html(reasonForCancellation);
  $("#cancellationDetails").html(cancellationDetails);

  $("#cancelledContentionModalId").dialog({
    modal: true,
    draggable: false,
    resizable: false,
    width: 600,
    dialogClass: 'ui-dialog-osx',
    buttons: {
        "Close": function() {
            $(this).dialog("close");
        }
    }
  });
  $(".ui-dialog-titlebar").hide();
}

function exam_request_jqdr() {
  $('#_request_date').datepicker({
    selectOtherMonths: true,
    changeMonth: true,
    changeYear: true
  });

  $('#select_contentions_submit').click(function(){
    $("#clarification_form").validate({
        debug: true,
        rules: get_clarification_form_rules(),
        messages: get_clarification_form_rule_messages(),
        submitHandler:  function(form) {
                          console.log($(form).valid());
                          if ($(form).valid()){
                            form.submit();
                          }
                          return false; // prevent normal form posting
                      }
    });

    $.validator.addMethod('primary', function (value) {
        return /^[(]{0,1}[0-9]{3}[)]{0,1}[-\s\.]{0,1}[0-9]{3}[-\s\.]{0,1}[0-9]{4}$/.test(value);
    }, 'Please enter a valid US phone number.');

    function get_clarification_form_rules(){
        var form_rules = {'primary': {primary: true},'alternate': {primary: true}};
        var text_fields =  get_clarification_form_names();
        for (var i = 0; i < text_fields.length; i++) {
            form_rules[text_fields[i]] = {required: true};
        }
        return form_rules;
    }

    function get_clarification_form_rule_messages(){
      var messages = {};
      var text_fields =  get_clarification_form_names();
      for (var i = 0; i < text_fields.length; i++) {
        messages[text_fields[i]] = 'Please enter the clarification field';
      }
      return messages;
    }

    function get_clarification_form_names(){
        return $.map($('.js-clarification'), function (key, value) {
          return key.getAttribute('name');
      });
    }
  });
}
