// Place all the behaviors and hooks related to the matching controller here.
// All this logic will automatically be available in application.js.
$(function(){
  $(".toggle-down").click( function() {
    $(".eval-content").toggle("slow");
    $(this).toggleClass("fa fa-chevron-circle-down fa fa-chevron-circle-up");
  });

  function getEvaluationTemplateHeaders() {
    return [
      {data: "name", render: function(data) {
          return "<span title='name'>"+data+"</a>";
        },
        targets: 0
      },
      {data: "edit", render: function(data) {
          return "<a href=\"" + data +"\" class='fa fa-pencil-square-o fa-lg' title='edit'></a>";
        },
        targets: 1, searchable: false, orderable: false
      },
      {data: "destroy", render: function(data) {
          return "<a data-method=\"delete\" data-confirm=\"Are you sure?\" class='fa fa-trash-o fa-lg' title='delete' href=\"" + data +"\"></a>";
        },
        targets: 2, searchable: false, orderable: false
      }
    ];
  };

  $("#evaluation-templates-index-table").DataTable({
    language: {
      lengthMenu: "Display _MENU_ Records",
      info: "Showing page _PAGE_ of _PAGES_ from a total of _MAX_ records"
    },
    columns: getEvaluationTemplateHeaders(),
    ajax: '/evaluation_templates/paged_list',
    processing: true,
    language: {
      processing: "<div><i class='fa fa-cog fa-2x fa-spin'></i></div>"
    },
    serverSide: true,
    pageLength: 25,
    columnDefs: [
        {"className": "name", "targets": [0]},
        {"className": "edit td-data-center", "targets": [1]},
        {"className": "destroy td-data-center", "targets": [2]}
      ],
    createdRow: function ( row, data, dataIndex ) {
      $(row).children('td').each (function(){
        var className = $(this).attr('class').replace('td-data-center','').trim();
        $(this).attr('headers', className);
      });
    }
  });

	$("[id$=-systems]").sortable({
		axis: 'y',
		update: function(event, ui) {
			$.ajax({
				type: "POST",
				url: $(this).data('update-url'),
				data:  $(this).sortable('serialize')
			});
		}
	});

	$("form.edit_evaluation_template #evaluation_template_id").chosen({
	  placeholder_text_multiple: "Associate Major Systems",
	  search_contains: true
	})

  function ajaxEvalTemplates(){
    var path = window.location.pathname,
      model = path.split('/')[1],
      id = path.split('/')[2],
      urlHtml = "/"+ model + "/" + id + "/generated_html";

    $.ajax({
      url:  urlHtml,
      type: 'GET',
      datatype:"json",
      timeout: 70000,
      beforeSend: function (){
        $('.displayed-text-area').html('<div><i class="fa fa-cog fa-2x fa-spin"></i><span class="loading-text"> Loading...</span></div>');
        $('.displayed-result').html('<div><i class="fa fa-cog fa-2x fa-spin"></i><span class="loading-text"> Loading...</span></div>');
      },
      success: function(data) {
        $('.displayed-text-area').html("<textarea name='generated_html_text' id='generated_html_text' rows='10'>"+ data + "</textarea>");
        $('.displayed-result').html( $('<div>').html("<h4><p>" + data + "</p></h4></div>").text() );
      }
    });
  };

  if (document.querySelector('.base-html') !== null){
    ajaxEvalTemplates();
  };

});
