// an override for the rails_jquery_ujs confirm action in order to make these confirm dialogs 508 compliant
$.rails.allowAction = function(link){

    if (link.data("confirm") == undefined){
        return true;
    }

    $.rails.showConfirmationDialog(link);
    return false;
}

// override for the user clicking the confirm button
$.rails.confirmed = function(link){
    link.data("confirm", null);
    link.trigger("click.rails");
}

// Custom confirm dialog
$.rails.showConfirmationDialog = function(link){

    var message = link.data("confirm");
    var dialogID = "cui_generated_confirm_dialog";
    var body = $("body");
    var position = {my: "center", at: "center", of: body};
    var dialogString = '<div id="' + dialogID + '"><div class="komet-confimation-dialog-message" role="alert" tabindex="0">' + message + '</div></div>';

    body.prepend(dialogString);
    var dialog = $("#" + dialogID);

    dialog.dialog({
        beforeClose: function () {
            dialog.remove();
        },
        title: "VA Clinician User Interface",
        resizable: false,
        height: "auto",
        width: 500,
        modal: true,
        position: position,
        dialogClass: "cui-confirmation-dialog cui-dialog-no-close-button",
        buttons: {
            Cancel: {
                "class": "btn btn-default",
                text: "Cancel",
                click: function () {
                    $(this).dialog("close");
                }
            },
            OK: {
                text: "OK",
                "class": "btn btn-primary",
                "id": dialogID + "_ok_button",
                click: function () {

                    $(this).dialog("close");
                    $.rails.confirmed(link);
                }
            }
        }
    });

    dialog.parent().children().children(".ui-dialog-titlebar-close").remove();
}