//JQuery 3 fix. Allows "load" to work in gems that require it.
jQuery.fn.load = function(callback){
    $(window).on("load", callback)
};

// modals
function closeModal(modal) {
    $(modal).foundation('reveal', 'close');
}

function pingServer() {
    // keep the server from timing out - called from application.html.haml
    $.ajax({
        type: "GET",
        url: "/pingserver",
        data: "",
        dataType: "",
    });
    // call again in 20 mins
    setTimeout(pingServer, 20*60*1000);
}

/* Feedback Form Alert Box */
function feedbackalert(){
    var feedbackalert = localStorage.getItem('feedbackalert') || '';
    if (feedbackalert != 'yes') {
        alert("Caution: Do not include any sensitive or classified information in feedback");
        localStorage.setItem('feedbackalert','yes');
    }
    $(window).on('beforeunload', function() {
        localStorage.setItem('feedbackalert','');
    });
}

// This function is used to sort Referral and Consult DataTables by Date and is called in referrals.js and consultations.js
function getColumnIndex(header,columnName) {
    for(var columnIndex = 0; columnIndex < header.length; columnIndex++)
    {
        if(header[columnIndex]["title"] == columnName)
        return columnIndex;
    }
    return -1;
}

// this function is called with each round trip to set up window functions and is called in _jq_doc_ready.js.erb
function app_setup() {
    $(function(){
        // Commented out the code below since the chosen() functionality
        // attached to these controls renders them out of compliance with 508
        // (The controls don't function properly at this time when a screen reader
        // running.  Thus we can't use this capability.)
        // note: 10/12/16 - john mcmanamon- reactivated the chosen functionalty
        // for the evaluation spec control below per user request.
        // This is temporary until a workaround can be found.
        $("#evaluation_evaluation_spec_id").chosen();
        $("#support_request_customer_site").chosen();
        //$("#user_id").chosen();
        //$("#site_select_id").chosen();
        //$("#site_selection_id").chosen();
        //$("#my_site_select_id").chosen();
        //$("#all_site_select_id").chosen();
        //
        function setDatepicker(id) {
            $(id).datepicker({
                selectOtherMonths: true,
                changeMonth: true,
                changeYear: true
            });
        }
        // 508 helper method that outputs message into a span
        // checks for a ctrl or cmd keypress plus arrow keys
        $('#examination_date').keydown(function(e) {
            var modifier = e.ctrlKey || e.metaKey
            if (modifier && e.keyCode >= 37 && e.keyCode <= 40) {
                var message = "" + $(".ui-state-hover").html() +
                    " " + $(".ui-datepicker-month").html() +
                    " " + $(".ui-datepicker-year").html();
                $('#liveRegion').html(message);
            }
        });

        setDatepicker("#examination_date");
        $("#veteran_birth_date").datepicker({
            selectOtherMonths: true,
            changeMonth: true,
            changeYear: true,
            defaultDate: new Date(1950,1)
        });
        setDatepicker("#elapsed_days");
        setDatepicker("#exam_request_start_date");
        setDatepicker("#exam_request_end_date");
        setDatepicker("#dates_");
        setDatepicker("#dates_e");

        $('#table_id').DataTable({
            "language": {
                "lengthMenu": "Display _MENU_ Records",
                "zeroRecords": "No records found",
                "info": "Showing page _PAGE_ of _PAGES_",
                "infoEmpty": "No records available",
                "infoFiltered": "(filtered from _MAX_ total records)"
            }
        });

        $('#ssn, #veteran_ssn').on('keydown keypress input blur', function(){
            if($(this).val() && $(this).val().length > 4){
                $(this).mask("000-00-0000");
            }else {
                $(this).unmask();
            }
        });

        $(".consultation-phone").mask("000-000-0000");

        // foundation has to be at the bottom of this function for some reason
        // it creates an issue with datepicker jquery
        $(document).foundation();
    });


// ===== Scroll to Top ====
// The below code is added for 'Return to top' functionallty
    $(window).scroll(function() {
        if ($(this).scrollTop() >= 50) {        // If page is scrolled more than 50px
            $('#return-to-top').fadeIn(200);    // Fade in the arrow
        } else {
            $('#return-to-top').fadeOut(200);   // Else fade out the arrow
        }
    });

    $('#return-to-top').click(function() {      // When arrow is clicked
        $('body,html').animate({
            scrollTop : 0                       // Scroll to top of body
        }, 500);

    });

    // wire up on('show') and on('hide') jquery events
    (function($) {
        $.each(['show', 'hide'], function(i, ev) {
            var el = $.fn[ev];
            $.fn[ev] = function() {
                this.trigger(ev);
                return el.apply(this, arguments);
            };
        });
    })(jQuery);

    // set up the vertical centering of modals
    $(window).resize(function(){
        $('.center_cui_modal').css({
            position:'absolute',
            top: ($(window).height() - $('.center_cui_modal').outerHeight())/2 + $(document).scrollTop()
        });
    });

    $(document).ready(function () {
        $(document)
            .on('opened.fndtn.reveal', function () {
                $(window).resize();
            })
            .on('scroll', function () {
                $(window).resize(); 
            });
    });

    $('.modal-cancel-button').on('click', function(){
        closeModal(this.closest('.reveal-modal'));
    });

}
