require 'rails_helper'

RSpec.describe "symptoms/edit", :type => :view do
  before(:each) do
    @symptom = assign(:symptom, Symptom.create!(
      :name => "MyString",
      :label => "MyString"
    ))
  end

  it "renders the edit symptom form" do
    render

    assert_select "form[action=?][method=?]", symptom_path(@symptom), "post" do

      assert_select "input#symptom_name[name=?]", "symptom[name]"

      assert_select "input#symptom_label[name=?]", "symptom[label]"
    end
  end
end
