require 'rails_helper'

RSpec.describe "general_questions/new", :type => :view do
  before(:each) do
    assign(:general_question, GeneralQuestion.new(
      :name => "MyString",
      :label => "MyString",
      :diagnosis_modifier_id => 1,
      :minor_system_id => 1
    ))
  end

  it "renders new general_question form" do
    render

    assert_select "form[action=?][method=?]", general_questions_path, "post" do

      assert_select "input#general_question_name[name=?]", "general_question[name]"

      assert_select "input#general_question_label[name=?]", "general_question[label]"

      assert_select "input#general_question_diagnosis_modifier_id[name=?]", "general_question[diagnosis_modifier_id]"

      assert_select "input#general_question_minor_system_id[name=?]", "general_question[minor_system_id]"
    end
  end
end
