require 'rails_helper'

RSpec.describe "examination_notes/edit", :type => :view do
  before(:each) do
    @examination_note = assign(:examination_note, ExaminationNote.create!(
      :from_id => 1,
      :to_id => 1,
      :note => "MyText",
      :type => ""
    ))
  end

  it "renders the edit examination_note form" do
    render

    assert_select "form[action=?][method=?]", examination_note_path(@examination_note), "post" do

      assert_select "input#examination_note_from_id[name=?]", "examination_note[from_id]"

      assert_select "input#examination_note_to_id[name=?]", "examination_note[to_id]"

      assert_select "textarea#examination_note_note[name=?]", "examination_note[note]"

      assert_select "input#examination_note_type[name=?]", "examination_note[type]"
    end
  end
end
