require 'rails_helper'

RSpec.describe "diagnosis_modifiers/new", :type => :view do
  before(:each) do
    assign(:diagnosis_modifier, DiagnosisModifier.new(
      :name => "MyString",
      :label => "MyString",
      :mod_type => "MyString",
      :list_values => "MyString",
      :html => "MyText"
    ))
  end

  it "renders new diagnosis_modifier form" do
    render

    assert_select "form[action=?][method=?]", diagnosis_modifiers_path, "post" do

      assert_select "input#diagnosis_modifier_name[name=?]", "diagnosis_modifier[name]"

      assert_select "input#diagnosis_modifier_label[name=?]", "diagnosis_modifier[label]"

      assert_select "input#diagnosis_modifier_mod_type[name=?]", "diagnosis_modifier[mod_type]"

      assert_select "input#diagnosis_modifier_list_values[name=?]", "diagnosis_modifier[list_values]"

      assert_select "textarea#diagnosis_modifier_html[name=?]", "diagnosis_modifier[html]"
    end
  end
end
