require 'rails_helper'

RSpec.describe "diagnoses/index", :type => :view do
  before(:each) do
    assign(:diagnoses, [
      Diagnosis.create!(
        :name => "Name",
        :label => "Label",
        :code => "Code"
      ),
      Diagnosis.create!(
        :name => "Name",
        :label => "Label",
        :code => "Code"
      )
    ])
  end

  it "renders a list of diagnoses" do
    render
    assert_select "tr>td", :text => "Name".to_s, :count => 2
    assert_select "tr>td", :text => "Label".to_s, :count => 2
    assert_select "tr>td", :text => "Code".to_s, :count => 2
  end
end
