require 'rails_helper'

RSpec.describe "alerts/new", :type => :view do
  before(:each) do
    assign(:alert, Alert.new(
      :user_id => 1,
      :description => "MyText",
      :active => ""
    ))
  end

  it "renders new alert form" do
    render

    assert_select "form[action=?][method=?]", alerts_path, "post" do

      assert_select "input#alert_user_id[name=?]", "alert[user_id]"

      assert_select "textarea#alert_description[name=?]", "alert[description]"

      assert_select "input#alert_active[name=?]", "alert[active]"
    end
  end
end
