require 'rails_helper'

RSpec.describe "alerts/index", :type => :view do
  before(:each) do
    assign(:alerts, [
      Alert.create!(
        :user_id => 1,
        :description => "MyText",
        :active => ""
      ),
      Alert.create!(
        :user_id => 1,
        :description => "MyText",
        :active => ""
      )
    ])
  end

  it "renders a list of alerts" do
    render
    assert_select "tr>td", :text => 1.to_s, :count => 2
    assert_select "tr>td", :text => "MyText".to_s, :count => 2
    assert_select "tr>td", :text => "".to_s, :count => 2
  end
end
