require 'rails_helper'
require 'mvi.rb'


# the actual unit testing spec
RSpec.describe 'MVI Proxy Add to Vista', cui: true do

  before do
    @veteran_hash = {
      :retrieve_person_request_id => "CUImmEvkiI2GefL6w==",
      :patient_icn => "1008713016V776783",
      :station_number => "523",
      :fname => "BOB",
      :lname => "ADELSON",
      :telecom_value => "571-123-1234",
      :telecom_usage => "HP",
      :gender => "M",
      :birth_date => "19500101",
      :addr_usage => "HP",
      :addr => {
        :street => "123 Main Street",
        :city => "Charleston",
        :state => "SC",
        :country => "USA",
        :zipcode => "29492"
      },
      :ssn => "555550100",
      :clinic_name => "Good Health Clinic",
      :clinic_phone => "tel:+1-342-555-8394"
    }
  end

  describe 'can add a veteran', cui: true do
    before do
      url = MVI::MVI_ENDPOINT_URL
      proxy_add_success_response = Rails.root.join("spec/support/mvi/proxy_add_to_vista_response.xml").read
      stub_request(:post, url).to_return(status: 200, body: proxy_add_success_response)
    end

    it 'to a valid vista site' do

      ack_message = MVI.proxy_add_to_vista @veteran_hash
      
      expect(ack_message).to eq("Correlation Proxy Added to VistA")
    end
  end

  describe 'cant add a veteran', cui: true do  
    before do 
      url = MVI::MVI_ENDPOINT_URL
      proxy_add_wrong_station_response = Rails.root.join("spec/support/mvi/proxy_add_incorrect_station_response.xml").read
      stub_request(:post, url).to_return(status: 200, body: proxy_add_wrong_station_response)
    end

    it 'to an invalid vista site' do
      
      expect{ MVI.proxy_add_to_vista @veteran_hash.merge({:station_number => "500"}) }.to raise_error("Proxy Add to Vista request errored out. Communication Failure with requested VistA Station")
    end
  end
end
