require 'rails_helper'

RSpec.describe MentalDisorderEvaluationPresenter do
  before do
    schema_xml = XML::Document.file(Rails.root.join("app/xsd/ExamResponse/exchange/ExamResponse-2.0.xsd").to_s)
    @schema = XML::Schema.document(schema_xml)
    claim = create(:claim, date_of_birth: Date.new(1900))
    contention = create(:contention)

    claim.contentions << contention
    allow_any_instance_of(Evaluation).to receive(:to_pdf) { "" }

    @evaluation_spec = EvaluationSpec.create(spec: File.read("app/exams/mental-health.yml"))
    evaluation = Evaluation.create(claim: claim, evaluation_spec: @evaluation_spec, user: create(:user))
    contention.evaluations << evaluation

    @spec_json = File.read("spec/evaluations/mental-health.json")
    evaluation.doc = @spec_json
    @evaluation_xml = evaluation.to_xml
    @doc = XML::Document.string(@evaluation_xml)
  end

  # it "should generate valid XML for a mental health exam" do
  #   doc = XML::Document.string(@evaluation_xml)
  #   doc.validate_schema(@schema)
  # end

  it "should set the mentalDisorderDiagnoses element to the selected diagnosis" do
    expect(@doc.find("//mdf:mentalDisorderDiagnoses/mdf:value").first.content).to eq "Bipolar disorder"
  end

  it "should not output the mental disorder diagnoses as a symptom" do
    expect(@doc.find("//mdf:mentalDisorderSymptoms/mdf:value[text()='Bipolar disorder']").size).to eq 0
  end

  context "when the eval is secondary, we output its parent as well" do
    before do
      user = create(:user)
      claim = create(:claim)
      claim.contentions << create(:contention, history: "This or That")

      dependent_eval = Evaluation.new(claim: claim, evaluation_spec: @evaluation_spec, user: user)
      dependent_eval.doc = @spec_json
      claim.contentions.first.evaluations << dependent_eval

      parent_eval = Evaluation.new(claim: claim, evaluation_spec: @evaluation_spec, completed_at: Time.now, user: user)
      parent_eval.doc = @spec_json
      claim.contentions.first.evaluations << parent_eval

      dependent_eval.primary_evaluation_id = parent_eval.id
      dependent_eval.save

      @evaluation_xml = dependent_eval.to_xml
    end

    # it "should include the parent eval" do
    #   xml = XML::Document.string(@evaluation_xml)
    #   facts = xml.find("//mdf:mentalDisorderFacts")
    #
    #   expect(facts.length).to eq 2
    #
    #   schema_xml = XML::Document.file(Rails.root.join("app/xsd/ExamResponse/exchange/ExamResponse-2.0.xsd").to_s)
    #   schema = XML::Schema.document(schema_xml)
    #   xml.validate_schema(schema)
    # end
  end
end
