require 'rails_helper'

RSpec.describe DentalAndOralEvaluationPresenter do
  before do
    @claim = create(:claim, date_of_birth: Date.new(1900))
    @contention = create(:contention)
    @claim.contentions << @contention
    @spec = create(:tmj_spec)
    @eval = create(:tmj_eval, claim: @claim, evaluation_spec: @spec, contentions: [@contention], user: create(:user))
    allow_any_instance_of(Evaluation).to receive(:to_pdf) { "" }
    @spec_json = File.read("spec/evaluations/dental.json")
  end

  # it "should generate valid XML for the TMJ eval" do
  #   doc = XML::Document.string(@eval.to_xml)
  #   sdoc = XML::Document.file(Rails.root.join("app/xsd/ExamResponse/exchange/ExamResponse-2.0.xsd").to_s)
  #   schema = XML::Schema.document(sdoc)
  #   doc.validate_schema(schema)
  # end

  context "when the eval is secondary, we output its parent as well" do
    before do
      user = create(:user)
      claim = create(:claim)
      claim.contentions << create(:contention, history: "This or That")

      dependent_eval = Evaluation.new(claim: claim, evaluation_spec: @spec, user: user)
      dependent_eval.doc = @spec_json
      claim.contentions.first.evaluations << dependent_eval

      parent_eval = Evaluation.new(claim: claim, evaluation_spec: @spec, completed_at: Time.now, user: user)
      parent_eval.doc = @spec_json
      claim.contentions.first.evaluations << parent_eval

      dependent_eval.primary_evaluation_id = parent_eval.id
      dependent_eval.save

      @evaluation_xml = dependent_eval.to_xml
    end

    # it "should include the parent eval" do
    #   xml = XML::Document.string(@evaluation_xml)
    #   facts = xml.find("//dentf:dentalFacts")
    #
    #   expect(facts.length).to eq 2
    #
    #   schema_xml = XML::Document.file(Rails.root.join("app/xsd/ExamResponse/exchange/ExamResponse-2.0.xsd").to_s)
    #   schema = XML::Schema.document(schema_xml)
    #   xml.validate_schema(schema)
    # end
  end
end
