# == Schema Information
#
# Table name: users
#
#  id                     :integer          not null, primary key
#  email                  :string           default(""), not null
#  encrypted_password     :string           default(""), not null
#  reset_password_token   :string
#  reset_password_sent_at :datetime
#  remember_created_at    :datetime
#  sign_in_count          :integer          default(0), not null
#  current_sign_in_at     :datetime
#  last_sign_in_at        :datetime
#  current_sign_in_ip     :inet
#  last_sign_in_ip        :inet
#  created_at             :datetime
#  updated_at             :datetime
#  roles                  :text
#  first_name             :string
#  last_name              :string
#  is_under_review        :boolean          default(TRUE)
#  failed_attempts        :integer          default(0)
#  unlock_token           :string
#  locked_at              :datetime
#  provider               :string
#  uid                    :string
#  authorization_state    :string           default("none")
#

require 'rails_helper'

RSpec.describe User, :type => :model do
  before do
    @user = User.new
  end

  context "under review" do
    it "should default to under review", cui: true do
      disabled_user = User.new(first_name: "a", last_name: "b", email: "a@example.com", password: "Password!123")
      disabled_user.save
      expect(disabled_user.is_under_review).to eq true
    end

    # it "should default to not under review if CUI_DISABLE_UNDER_REVIEW is present" do
    #   ENV["CUI_DISABLE_UNDER_REVIEW"] = "true"
    #   enabled_user = User.new(first_name: "a", last_name: "b", email: "a@example.com", password: "password")
    #   enabled_user.save
    #   expect(enabled_user.is_under_review).to eq false
    #   ENV.delete "CUI_DISABLE_UNDER_REVIEW"
    # end
  end

  describe "#incomplete_claims" do
    before do
      @examiner = create(:examiner)
      @evaluation_spec = create(:diabetes_spec)
      @claim = create(:claim)
      @claim.contentions << create(:contention, history: "Some bogus history")
      @evaluation = Evaluation.new(claim: @claim,
                                   evaluation_spec: @evaluation_spec,
                                   doc: build(:diabetes_doc).doc,
                                   completed_at: Time.now,
                                   user: @examiner)
      @claim.contentions.first.evaluations << @evaluation
      @examiner2 = create(:examiner)
    end

    it "should return a claim for the examiner with an evaluation outstanding", cui: true do
      expect(@examiner.incomplete_claims.length).to eq 1
      expect(@examiner.incomplete_claims[0]).to eq @claim
    end

    it "should not return an evaluation for the examiner without an evaluation outstanding", cui: true do
      expect(@examiner2.incomplete_claims.length).to eq 0
    end
  end
end
