# == Schema Information
#
# Table name: referral_document_types
#
#  id         :integer          not null, primary key
#  sequence   :string           not null
#  title      :string           not null
#  deleted_at :datetime
#

require 'rails_helper'

RSpec.describe ReferralDocumentType, :type => :model do

  describe "ParanoidModelTest", cpp: true do
    it_behaves_like 'a Paranoid model'
  end

  context "associations" do
    it "should have multiple referral documents", cpp: true do
      referral_document_type = ReferralDocumentType.reflect_on_association(:referral_documents)
      expect(referral_document_type.macro).to eq :has_many
    end
  end

  context "methods" do

    it "should return an array of all the referral document types", cpp: true do
      expect(ReferralDocumentType.to_dropdown.count).to eq ReferralDocumentType.count
    end
  end
end
